/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class XBeanByteConverterUtil {
    private static final Pattern[] BYTE_MATCHERS = new Pattern[]{Pattern.compile("^\\s*(\\d+)\\s*(b)?\\s*$", 2), Pattern.compile("^\\s*(\\d+)\\s*k(b)?\\s*$", 2), Pattern.compile("^\\s*(\\d+)\\s*m(b)?\\s*$", 2), Pattern.compile("^\\s*(\\d+)\\s*g(b)?\\s*$", 2)};

    private XBeanByteConverterUtil() {
    }

    public static Long convertToLongBytes(String str) throws IllegalArgumentException {
        for (int i2 = 0; i2 < BYTE_MATCHERS.length; ++i2) {
            Matcher matcher = BYTE_MATCHERS[i2].matcher(str);
            if (!matcher.matches()) continue;
            long value = Long.parseLong(matcher.group(1));
            for (int j = 1; j <= i2; ++j) {
                value *= 1024L;
            }
            return value;
        }
        throw new IllegalArgumentException("Could not convert to a memory size: " + str);
    }

    public static Integer convertToIntegerBytes(String str) throws IllegalArgumentException {
        for (int i2 = 0; i2 < BYTE_MATCHERS.length; ++i2) {
            Matcher matcher = BYTE_MATCHERS[i2].matcher(str);
            if (!matcher.matches()) continue;
            int value = Integer.parseInt(matcher.group(1));
            for (int j = 1; j <= i2; ++j) {
                value *= 1024;
            }
            return value;
        }
        throw new IllegalArgumentException("Could not convert to a memory size: " + str);
    }
}

