/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import org.apache.camel.component.jms.DestinationEndpoint;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsQueueEndpoint;
import org.apache.camel.component.jms.QueueBrowseStrategy;

public class JmsTemporaryQueueEndpoint
extends JmsQueueEndpoint
implements DestinationEndpoint {
    private Destination jmsDestination;

    public JmsTemporaryQueueEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration) {
        super(uri, component, destination, configuration);
        this.setDestinationType("temp-queue");
    }

    public JmsTemporaryQueueEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        super(uri, component, destination, configuration, queueBrowseStrategy);
        this.setDestinationType("temp-queue");
    }

    public JmsTemporaryQueueEndpoint(String endpointUri, String destination) {
        super(endpointUri, destination);
        this.setDestinationType("temp-queue");
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public Destination getJmsDestination(Session session) throws JMSException {
        this.lock.lock();
        try {
            if (this.jmsDestination == null) {
                this.jmsDestination = this.createJmsDestination(session);
            }
            Destination destination = this.jmsDestination;
            return destination;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Destination createJmsDestination(Session session) throws JMSException {
        return session.createTemporaryQueue();
    }
}

