/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenWireFrameParser
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final int openwireMaxPacketChunkSize;
    ByteBuf outBuffer;
    int bufferSize = -1;

    public OpenWireFrameParser(int openwireMaxPacketChunkSize) {
        this.openwireMaxPacketChunkSize = openwireMaxPacketChunkSize;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (ctx.isRemoved()) {
            return;
        }
        if (this.bufferSize == -1) {
            if (in.readableBytes() < 4) {
                return;
            }
            this.bufferSize = in.getInt(in.readerIndex()) + 4;
            if (this.openwireMaxPacketChunkSize > 0 && this.bufferSize > this.openwireMaxPacketChunkSize) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Creating a heapBuffer sized as {} as it is beyond {} chunk limit", (Object)this.bufferSize, (Object)this.openwireMaxPacketChunkSize);
                }
                this.outBuffer = UnpooledByteBufAllocator.DEFAULT.heapBuffer(this.bufferSize);
            }
        }
        if (this.outBuffer != null) {
            int missingBytes = this.bufferSize - this.outBuffer.writerIndex();
            int bytesToRead = Math.min(missingBytes, in.readableBytes());
            this.outBuffer.writeBytes(in, bytesToRead);
            if (this.outBuffer.writerIndex() == this.bufferSize) {
                out.add(this.outBuffer);
                this.outBuffer = null;
                this.bufferSize = -1;
            }
        } else if (in.readableBytes() >= this.bufferSize) {
            out.add(in.retainedSlice(in.readerIndex(), this.bufferSize));
            in.skipBytes(this.bufferSize);
            this.outBuffer = null;
            this.bufferSize = -1;
        }
    }
}

