/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.meta.JmsAbstractResourceId;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsSessionId;

public final class JmsConnectionId
extends JmsAbstractResourceId
implements Comparable<JmsConnectionId> {
    private final String value;

    public JmsConnectionId(String connectionId) {
        if (connectionId == null || connectionId.isEmpty()) {
            throw new IllegalArgumentException("Connection ID cannot be null or empty");
        }
        this.value = connectionId;
    }

    public JmsConnectionId(JmsConnectionId id) {
        if (id == null) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        this.value = id.getValue();
    }

    public JmsConnectionId(JmsSessionId id) {
        if (id == null) {
            throw new IllegalArgumentException("Session ID cannot be null");
        }
        this.value = id.getConnectionId();
    }

    public JmsConnectionId(JmsProducerId id) {
        if (id == null) {
            throw new IllegalArgumentException("Producer ID cannot be null");
        }
        this.value = id.getConnectionId();
    }

    public JmsConnectionId(JmsConsumerId id) {
        if (id == null) {
            throw new IllegalArgumentException("Consumer ID cannot be null");
        }
        this.value = id.getConnectionId();
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = 31 * this.hashCode + this.value.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != JmsConnectionId.class) {
            return false;
        }
        JmsConnectionId id = (JmsConnectionId)o;
        return this.value.equals(id.value);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public int compareTo(JmsConnectionId o) {
        return this.value.compareTo(o.value);
    }
}

