/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service;

import com.google.common.base.Stopwatch;
import com.twitter.finagle.Service;
import com.twitter.finagle.SimpleFilter;
import com.twitter.util.Future;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;

class StatsFilter<Req, Rep>
extends SimpleFilter<Req, Rep> {
    private final StatsLogger stats;
    private final Counter outstandingAsync;
    private final OpStatsLogger serviceExec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Rep> apply(Req req, Service<Req, Rep> service) {
        Future result = null;
        this.outstandingAsync.inc();
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            result = service.apply(req);
            this.serviceExec.registerSuccessfulEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        }
        finally {
            this.outstandingAsync.dec();
            if (null == result) {
                this.serviceExec.registerFailedEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            }
        }
        return result;
    }

    public StatsFilter(StatsLogger stats) {
        this.stats = stats;
        this.outstandingAsync = stats.getCounter("outstandingAsync");
        this.serviceExec = stats.getOpStatsLogger("serviceExec");
    }
}

