/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle;

import com.twitter.finagle.ChannelClosedException;
import com.twitter.finagle.ChannelException;
import com.twitter.finagle.ConnectionFailedException;
import com.twitter.finagle.UnknownChannelException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.UnresolvedAddressException;
import scala.Serializable;

public final class ChannelException$
implements Serializable {
    public static final ChannelException$ MODULE$;

    static {
        new ChannelException$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChannelException apply(Throwable cause, SocketAddress remoteAddress) {
        boolean bl = false;
        IOException iOException = null;
        Throwable throwable = cause;
        if (throwable instanceof ChannelException) {
            ChannelException channelException = (ChannelException)throwable;
            return channelException;
        }
        if (throwable instanceof ConnectException) {
            return new ConnectionFailedException(cause, remoteAddress);
        }
        if (throwable instanceof UnresolvedAddressException) {
            return new ConnectionFailedException(cause, remoteAddress);
        }
        if (throwable instanceof ClosedChannelException) {
            return new ChannelClosedException(cause, remoteAddress);
        }
        if (throwable instanceof IOException) {
            bl = true;
            iOException = (IOException)throwable;
            if ("Connection reset by peer".equals(iOException.getMessage())) {
                return new ChannelClosedException(cause, remoteAddress);
            }
        }
        if (bl && "Broken pipe".equals(iOException.getMessage())) {
            return new ChannelClosedException(cause, remoteAddress);
        }
        if (!bl) return new UnknownChannelException(cause, remoteAddress);
        if (!"Connection timed out".equals(iOException.getMessage())) return new UnknownChannelException(cause, remoteAddress);
        return new ConnectionFailedException(cause, remoteAddress);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ChannelException$() {
        MODULE$ = this;
    }
}

