/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Data;
import com.twitter.common.quantity.Unit;
import com.twitter.common.stats.Histogram;
import com.twitter.common.stats.Histograms;
import com.twitter.common.stats.Precision;
import java.util.Arrays;

public final class ApproximateHistogram
implements Histogram {
    @VisibleForTesting
    public static final Precision DEFAULT_PRECISION = new Precision(0.02, 100000);
    @VisibleForTesting
    public static final Amount<Long, Data> DEFAULT_MAX_MEMORY = Amount.of((long)12L, (Unit)Data.KB);
    @VisibleForTesting
    static final long ELEM_SIZE = 8L;
    @VisibleForTesting
    long[][] buffer;
    @VisibleForTesting
    long count = 0L;
    @VisibleForTesting
    int leafCount = 0;
    @VisibleForTesting
    int currentTop = 1;
    @VisibleForTesting
    int[] indices;
    private boolean leavesSorted = true;
    private int rootWeight = 1;
    private long[][] bufferPool;
    private int bufferSize;
    private int maxDepth;

    @VisibleForTesting
    void init(int n, int n2) {
        this.bufferSize = n;
        this.maxDepth = n2;
        this.bufferPool = new long[2][this.bufferSize];
        this.indices = new int[n2 + 1];
        this.buffer = new long[n2 + 1][this.bufferSize];
        this.allocate(0);
        this.allocate(1);
        Arrays.fill((Object[])this.buffer, 2, this.buffer.length, null);
        this.clear();
    }

    @VisibleForTesting
    ApproximateHistogram(int n, int n2) {
        this.init(n, n2);
    }

    public ApproximateHistogram(Precision precision) {
        Preconditions.checkNotNull((Object)precision);
        int n = ApproximateHistogram.computeDepth(precision.getEpsilon(), precision.getN());
        int n2 = ApproximateHistogram.computeBufferSize(n, precision.getN());
        this.init(n2, n);
    }

    public ApproximateHistogram(Amount<Long, Data> amount, int n) {
        Preconditions.checkNotNull(amount);
        Preconditions.checkArgument((1024L <= (Long)amount.as((Unit)Data.BYTES) ? 1 : 0) != 0, (Object)"at least 1KB is required for an Histogram");
        double d = DEFAULT_PRECISION.getEpsilon();
        int n2 = n;
        int n3 = ApproximateHistogram.computeDepth(d, n2);
        int n4 = ApproximateHistogram.computeBufferSize(n3, n2);
        long l = (Long)amount.as((Unit)Data.BYTES);
        boolean bl = ApproximateHistogram.memoryUsage(n4, n3) > l;
        double d2 = bl ? 1.05 : 0.95;
        while (l < ApproximateHistogram.memoryUsage(n4, n3) == bl) {
            if ((d *= d2) < 1.0E-5) {
                n2 *= 10;
                d = DEFAULT_PRECISION.getEpsilon();
            }
            n3 = ApproximateHistogram.computeDepth(d, n2);
            n4 = ApproximateHistogram.computeBufferSize(n3, n2);
        }
        if (!bl) {
            n3 = ApproximateHistogram.computeDepth(d / d2, n2);
            n4 = ApproximateHistogram.computeBufferSize(n3, n2);
        }
        this.init(n4, n3);
    }

    public ApproximateHistogram(Amount<Long, Data> amount) {
        this(amount, DEFAULT_PRECISION.getN());
    }

    public ApproximateHistogram() {
        this(DEFAULT_MAX_MEMORY);
    }

    @Override
    public synchronized void add(long l) {
        if (this.leafCount == 2 * this.bufferSize) {
            Arrays.sort(this.buffer[0]);
            Arrays.sort(this.buffer[1]);
            this.recCollapse(this.buffer[0], 1);
            this.leafCount = 0;
        }
        if (this.leafCount < this.bufferSize) {
            this.buffer[0][this.leafCount] = l;
        } else {
            this.buffer[1][this.leafCount - this.bufferSize] = l;
        }
        ++this.leafCount;
        ++this.count;
        this.leavesSorted = this.leafCount == 1;
    }

    @Override
    public synchronized long getQuantile(double d) {
        int n;
        Preconditions.checkArgument((0.0 <= d && d <= 1.0 ? 1 : 0) != 0, (Object)"quantile must be in the range 0.0 to 1.0 inclusive");
        if (this.count == 0L) {
            return 0L;
        }
        int n2 = Math.min(this.bufferSize, this.leafCount);
        int n3 = Math.max(0, this.leafCount - n2);
        long l = 0L;
        long l2 = (long)Math.ceil((double)this.count * (1.0 - d));
        if (!this.leavesSorted) {
            Arrays.sort(this.buffer[0], 0, n2);
            Arrays.sort(this.buffer[1], 0, n3);
            this.leavesSorted = true;
        }
        Arrays.fill(this.indices, this.bufferSize - 1);
        this.indices[0] = n2 - 1;
        this.indices[1] = n3 - 1;
        do {
            int n4 = n = this.biggest(this.indices);
            this.indices[n4] = this.indices[n4] - 1;
        } while ((l += (long)this.weight(n)) < l2);
        return this.buffer[n][this.indices[n] + 1];
    }

    @Override
    public synchronized long[] getQuantiles(double[] dArray) {
        return Histograms.extractQuantiles(this, dArray);
    }

    @Override
    public synchronized void clear() {
        this.count = 0L;
        this.leafCount = 0;
        this.currentTop = 1;
        this.rootWeight = 1;
        this.leavesSorted = true;
    }

    public static Histogram merge(ApproximateHistogram[] approximateHistogramArray) {
        return new MergedHistogram(approximateHistogramArray);
    }

    @VisibleForTesting
    static int computeDepth(double d, long l) {
        int n = 2;
        while ((double)((long)(n - 2) * (1L << n - 2)) + 0.5 <= d * (double)l) {
            ++n;
        }
        return n;
    }

    @VisibleForTesting
    static int computeBufferSize(int n, long l) {
        return (int)(l / (1L << n - 1));
    }

    @VisibleForTesting
    static long memoryUsage(int n, int n2) {
        return (long)(176 + 24 * n2) + (long)n * 8L * (long)(n2 + 3);
    }

    @VisibleForTesting
    int biggest(int[] nArray) {
        long l;
        long l2 = Long.MIN_VALUE;
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = -1;
        if (0 < this.leafCount && 0 <= n) {
            l2 = this.buffer[0][n];
            n3 = 0;
        }
        if (this.bufferSize < this.leafCount && 0 <= n2 && (l = this.buffer[1][n2]) > l2) {
            l2 = l;
            n3 = 1;
        }
        for (int i = 2; i < this.currentTop + 1; ++i) {
            long l3;
            if (this.isBufferEmpty(i) || 0 > nArray[i] || (l3 = this.buffer[i][nArray[i]]) <= l2) continue;
            l2 = l3;
            n3 = i;
        }
        return n3;
    }

    @VisibleForTesting
    boolean isBufferEmpty(int n) {
        if (n == this.currentTop) {
            return false;
        }
        long l = 1 << n - 1;
        return ((this.count - (long)this.leafCount) / (long)this.bufferSize & l) == 0L;
    }

    private int weight(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == this.maxDepth) {
            return this.rootWeight;
        }
        return 1 << n - 1;
    }

    private void allocate(int n) {
        if (this.buffer[n] == null) {
            this.buffer[n] = new long[this.bufferSize];
        }
    }

    private void recCollapse(long[] lArray, int n) {
        if (n == this.maxDepth) {
            int n2 = 1 << n - 1;
            int n3 = n % 2;
            long[] lArray2 = this.bufferPool[n3];
            long[] lArray3 = this.buffer[n];
            ApproximateHistogram.collapse(lArray, n2, this.buffer[n], this.rootWeight, lArray2);
            this.buffer[n] = lArray2;
            this.bufferPool[n3] = lArray3;
            this.rootWeight += n2;
        } else {
            this.allocate(n + 1);
            if (n == this.currentTop) {
                ApproximateHistogram.collapse1(lArray, this.buffer[n], this.buffer[n + 1]);
                ++this.currentTop;
                this.rootWeight *= 2;
            } else if (this.isBufferEmpty(n + 1)) {
                ApproximateHistogram.collapse1(lArray, this.buffer[n], this.buffer[n + 1]);
            } else {
                long[] lArray4 = this.bufferPool[n % 2];
                ApproximateHistogram.collapse1(lArray, this.buffer[n], lArray4);
                this.recCollapse(lArray4, n + 1);
            }
        }
    }

    @VisibleForTesting
    static void collapse(long[] lArray, int n, long[] lArray2, int n2, long[] lArray3) {
        int n3 = n + n2;
        int n4 = n3 / 2 - 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n5 < lArray.length || n6 < lArray2.length) {
            int n9;
            long l;
            if (n5 < lArray.length && (n6 == lArray2.length || lArray[n5] < lArray2[n6])) {
                l = lArray[n5];
                n9 = n;
                ++n5;
            } else {
                l = lArray2[n6];
                n9 = n2;
                ++n6;
            }
            int n10 = (n8 + n4) / n3;
            int n11 = ((n8 += n9) + n4) / n3;
            while (n10 < n11) {
                lArray3[n7] = l;
                ++n7;
                ++n10;
            }
        }
    }

    private static void collapse1(long[] lArray, long[] lArray2, long[] lArray3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n < lArray.length || n2 < lArray2.length) {
            long l;
            if (n < lArray.length && (n2 == lArray2.length || lArray[n] < lArray2[n2])) {
                l = lArray[n];
                ++n;
            } else {
                l = lArray2[n2];
                ++n2;
            }
            if (n4 % 2 == 1) {
                lArray3[n3] = l;
                ++n3;
            }
            ++n4;
        }
    }

    private static class MergedHistogram
    implements Histogram {
        private final ApproximateHistogram[] histograms;

        private MergedHistogram(ApproximateHistogram[] approximateHistogramArray) {
            this.histograms = approximateHistogramArray;
        }

        @Override
        public void add(long l) {
            assert (false);
        }

        @Override
        public void clear() {
            assert (false);
        }

        @Override
        public long getQuantile(double d) {
            Preconditions.checkArgument((0.0 <= d && d <= 1.0 ? 1 : 0) != 0, (Object)"quantile must be in the range 0.0 to 1.0 inclusive");
            long l = this.initIndices();
            if (l == 0L) {
                return 0L;
            }
            long l2 = 0L;
            long l3 = (long)Math.ceil((double)l * (1.0 - d));
            int n = -1;
            int n2 = -1;
            do {
                long l4 = Long.MIN_VALUE;
                for (int i = 0; i < this.histograms.length; ++i) {
                    ApproximateHistogram approximateHistogram = this.histograms[i];
                    int n3 = approximateHistogram.biggest(approximateHistogram.indices);
                    if (n3 < 0) continue;
                    long l5 = approximateHistogram.buffer[n3][approximateHistogram.indices[n3]];
                    if (n2 != -1 && l4 > l5) continue;
                    n2 = n3;
                    l4 = l5;
                    n = i;
                }
                int n4 = n2;
                this.histograms[n].indices[n4] = this.histograms[n].indices[n4] - 1;
            } while ((l2 += (long)this.histograms[n].weight(n2)) < l3);
            ApproximateHistogram approximateHistogram = this.histograms[n];
            int n5 = approximateHistogram.indices[n2];
            return approximateHistogram.buffer[n2][n5 + 1];
        }

        @Override
        public synchronized long[] getQuantiles(double[] dArray) {
            return Histograms.extractQuantiles(this, dArray);
        }

        private long initIndices() {
            long l = 0L;
            for (int i = 0; i < this.histograms.length; ++i) {
                ApproximateHistogram approximateHistogram = this.histograms[i];
                int[] nArray = approximateHistogram.indices;
                l += approximateHistogram.count;
                int n = Math.min(approximateHistogram.bufferSize, approximateHistogram.leafCount);
                int n2 = Math.max(0, approximateHistogram.leafCount - n);
                if (!approximateHistogram.leavesSorted) {
                    Arrays.sort(approximateHistogram.buffer[0], 0, n);
                    Arrays.sort(approximateHistogram.buffer[1], 0, n2);
                    approximateHistogram.leavesSorted = true;
                }
                Arrays.fill(nArray, approximateHistogram.bufferSize - 1);
                nArray[0] = n - 1;
                nArray[1] = n2 - 1;
            }
            return l;
        }
    }
}

