/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Preconditions;
import com.twitter.common.stats.SampledStat;
import com.twitter.common.stats.Stat;
import com.twitter.common.stats.Stats;
import java.util.concurrent.LinkedBlockingDeque;

public class MovingAverage<T extends Number>
extends SampledStat<Double> {
    private static final int DEFAULT_WINDOW = 10;
    private final Stat<T> input;
    private final LinkedBlockingDeque<T> samples;
    private double sampleSum = 0.0;

    private MovingAverage(String name, Stat<T> input, int windowSize) {
        super(name, 0.0);
        Preconditions.checkArgument((windowSize > 1 ? 1 : 0) != 0);
        this.input = (Stat)Preconditions.checkNotNull(input);
        this.samples = new LinkedBlockingDeque(windowSize);
        Stats.export(input);
    }

    public static <T extends Number> MovingAverage<T> of(Stat<T> input) {
        return MovingAverage.of(input, 10);
    }

    public static <T extends Number> MovingAverage<T> of(Stat<T> input, int windowSize) {
        return MovingAverage.of(String.format("%s_avg", input.getName()), input, windowSize);
    }

    public static <T extends Number> MovingAverage<T> of(String name, Stat<T> input, int windowSize) {
        return new MovingAverage<T>(name, input, windowSize);
    }

    @Override
    public Double doSample() {
        Number sample = (Number)this.input.read();
        if (this.samples.remainingCapacity() == 0) {
            this.sampleSum -= ((Number)this.samples.removeLast()).doubleValue();
        }
        this.samples.addFirst(sample);
        this.sampleSum += sample.doubleValue();
        return this.sampleSum / (double)this.samples.size();
    }
}

