/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.jmx;

import java.util.Enumeration;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedUtil.class);

    private static final boolean isLog4jJmxEnabled() {
        boolean enabled = false;
        try {
            Class.forName("org.apache.log4j.spi.LoggerRepository");
            if (Boolean.getBoolean("zookeeper.jmx.log4j.disable")) {
                LOG.info("Log4j found but jmx support is disabled.");
            } else {
                enabled = true;
                LOG.info("Log4j found with jmx enabled.");
            }
        }
        catch (ClassNotFoundException e) {
            LOG.info("Log4j not found.");
        }
        return enabled;
    }

    public static void registerLog4jMBeans() throws JMException {
        if (ManagedUtil.isLog4jJmxEnabled()) {
            LOG.debug("registerLog4jMBeans()");
            MBeanServer mbs = MBeanRegistry.getInstance().getPlatformMBeanServer();
            try {
                Object hdm = Class.forName("org.apache.log4j.jmx.HierarchyDynamicMBean").newInstance();
                ObjectName mbo = new ObjectName("log4j:hiearchy=default");
                mbs.registerMBean(hdm, mbo);
                Object rootLogger = Class.forName("org.apache.log4j.Logger").getMethod("getRootLogger", null).invoke(null, (Object[])null);
                Object rootLoggerName = rootLogger.getClass().getMethod("getName", null).invoke(rootLogger, (Object[])null);
                hdm.getClass().getMethod("addLoggerMBean", String.class).invoke(hdm, rootLoggerName);
                Object r = Class.forName("org.apache.log4j.LogManager").getMethod("getLoggerRepository", null).invoke(null, (Object[])null);
                Enumeration enumer = (Enumeration)r.getClass().getMethod("getCurrentLoggers", null).invoke(r, (Object[])null);
                while (enumer.hasMoreElements()) {
                    Object logger = enumer.nextElement();
                    Object loggerName = logger.getClass().getMethod("getName", null).invoke(logger, (Object[])null);
                    hdm.getClass().getMethod("addLoggerMBean", String.class).invoke(hdm, loggerName);
                }
            }
            catch (Exception e) {
                LOG.error("Problems while registering log4j jmx beans!", (Throwable)e);
                throw new JMException(e.toString());
            }
        }
    }
}

