/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util.concurrent;

import com.google.common.base.Supplier;
import com.twitter.common.util.concurrent.ForwardingExecutorService;
import com.twitter.common.util.concurrent.TaskConverter;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ExceptionHandlingScheduledExecutorService
extends ForwardingExecutorService<ScheduledExecutorService>
implements ScheduledExecutorService {
    private final Supplier<Thread.UncaughtExceptionHandler> handler;

    ExceptionHandlingScheduledExecutorService(ScheduledExecutorService delegate, Supplier<Thread.UncaughtExceptionHandler> handler) {
        super(delegate);
        this.handler = handler;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        return ((ScheduledExecutorService)this.delegate).schedule(TaskConverter.alertingRunnable(runnable, this.handler), delay, timeUnit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit timeUnit) {
        return ((ScheduledExecutorService)this.delegate).schedule(TaskConverter.alertingCallable(callable, this.handler), delay, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        return ((ScheduledExecutorService)this.delegate).scheduleAtFixedRate(TaskConverter.alertingRunnable(runnable, this.handler), initialDelay, period, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long initialDelay, long delay, TimeUnit timeUnit) {
        return ((ScheduledExecutorService)this.delegate).scheduleWithFixedDelay(TaskConverter.alertingRunnable(runnable, this.handler), initialDelay, delay, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return ((ScheduledExecutorService)this.delegate).submit(TaskConverter.alertingCallable(task, this.handler));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return ((ScheduledExecutorService)this.delegate).submit(TaskConverter.alertingRunnable(task, this.handler), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return ((ScheduledExecutorService)this.delegate).submit(TaskConverter.alertingRunnable(task, this.handler));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return ((ScheduledExecutorService)this.delegate).invokeAll(TaskConverter.alertingCallables(tasks, this.handler));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return ((ScheduledExecutorService)this.delegate).invokeAll(TaskConverter.alertingCallables(tasks, this.handler), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)((ScheduledExecutorService)this.delegate).invokeAny(TaskConverter.alertingCallables(tasks, this.handler));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)((ScheduledExecutorService)this.delegate).invokeAny(TaskConverter.alertingCallables(tasks, this.handler), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        ((ScheduledExecutorService)this.delegate).execute(TaskConverter.alertingRunnable(command, this.handler));
    }
}

