/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark.stream;

import org.apache.commons.cli.CommandLine;
import org.apache.distributedlog.benchmark.stream.ReadMode;
import org.apache.distributedlog.benchmark.stream.StreamBenchmark;
import org.apache.distributedlog.benchmark.stream.SyncReaderBenchmark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractReaderBenchmark
extends StreamBenchmark {
    private static final Logger logger = LoggerFactory.getLogger(SyncReaderBenchmark.class);
    protected ReadMode readMode = ReadMode.LATEST;
    protected long fromTxId = -999L;
    protected long rewindMs = 0L;
    protected int batchSize = 1;

    protected AbstractReaderBenchmark() {
        this.options.addOption("t", "tx-id", true, "Transaction ID to start read from when reading in mode 'position'");
        this.options.addOption("r", "rewind", true, "Time to rewind back to read from when reading in mode 'rewind' (in milliseconds)");
        this.options.addOption("m", "mode", true, "Read Mode : [oldest, latest, rewind, position]");
        this.options.addOption("b", "batch-size", true, "Read batch size");
    }

    @Override
    protected void parseCommandLine(CommandLine cmdline) {
        if (cmdline.hasOption("m")) {
            String mode = cmdline.getOptionValue("m");
            try {
                this.readMode = ReadMode.valueOf(mode.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                logger.error("Invalid read mode {}.", (Object)mode);
                this.printUsage();
                System.exit(0);
            }
        } else {
            this.printUsage();
            System.exit(0);
        }
        if (cmdline.hasOption("t")) {
            this.fromTxId = Long.parseLong(cmdline.getOptionValue("t"));
        }
        if (cmdline.hasOption("r")) {
            this.rewindMs = Long.parseLong(cmdline.getOptionValue("r"));
        }
        if (cmdline.hasOption("b")) {
            this.batchSize = Integer.parseInt(cmdline.getOptionValue("b"));
        }
        logger.info("Start reading from transaction id {}, rewind {} ms.", (Object)this.fromTxId, (Object)this.rewindMs);
    }
}

