/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args.parsers;

import com.google.common.base.Preconditions;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.TypeUtil;
import com.twitter.common.args.parsers.TypeParameterizedParser;
import java.lang.reflect.Type;
import java.util.List;

public class ClassParser
extends TypeParameterizedParser<Class<?>> {
    public ClassParser() {
        super(1);
    }

    @Override
    public Class<?> doParse(ParserOracle parserOracle, String raw, List<Type> typeParams) {
        Class<?> rawClassType = TypeUtil.getRawType(typeParams.get(0));
        try {
            Class<?> actualClass = Class.forName(raw);
            Preconditions.checkArgument((boolean)rawClassType.isAssignableFrom(actualClass));
            return actualClass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find class " + raw);
        }
    }
}

