/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.protocol.util;

import com.google.common.collect.Lists;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import com.twitter.util.Return;
import com.twitter.util.Try;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.distributedlog.common.concurrent.FutureUtils;

public final class TwitterFutureUtils {
    private TwitterFutureUtils() {
    }

    public static <T> CompletableFuture<T> newJFuture(Promise<T> promise) {
        CompletableFuture jFuture = FutureUtils.createFuture();
        jFuture.whenComplete((value, cause) -> {
            if (null != cause) {
                if (cause instanceof CompletionException) {
                    promise.setException(cause.getCause());
                } else {
                    promise.setException(cause);
                }
            } else {
                promise.setValue(value);
            }
        });
        return jFuture;
    }

    public static <T> Future<T> newTFuture(CompletableFuture<T> jFuture) {
        Promise promise = new Promise();
        jFuture.whenComplete((value, cause) -> {
            if (null != cause) {
                if (cause instanceof CompletionException) {
                    promise.setException(cause.getCause());
                } else {
                    promise.setException(cause);
                }
            } else {
                promise.setValue(value);
            }
        });
        return promise;
    }

    public static <T> Future<List<Future<T>>> newTFutureList(CompletableFuture<List<CompletableFuture<T>>> jFutureList) {
        Promise promise = new Promise();
        jFutureList.whenComplete((value, cause) -> {
            if (null != cause) {
                if (cause instanceof CompletionException) {
                    promise.setException(cause.getCause());
                } else {
                    promise.setException(cause);
                }
            } else {
                promise.setValue((Object)Lists.transform((List)value, future -> TwitterFutureUtils.newTFuture(future)));
            }
        });
        return promise;
    }

    public static <T> void setValue(Promise<T> promise, T value) {
        promise.updateIfEmpty((Try)new Return(value));
    }
}

