/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.zk;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKWatcherManager
implements Watcher {
    static final Logger logger = LoggerFactory.getLogger(ZKWatcherManager.class);
    private final String name;
    private final ZooKeeperClient zkc;
    private final StatsLogger statsLogger;
    private final Gauge<Number> totalWatchesGauge;
    private static final String totalWatchesGauageLabel = "total_watches";
    private final Gauge<Number> numChildWatchesGauge;
    private static final String numChildWatchesGauageLabel = "num_child_watches";
    protected final ConcurrentMap<String, Set<Watcher>> childWatches;
    protected final AtomicInteger allWatchesGauge;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ZKWatcherManager(String name, ZooKeeperClient zkc, StatsLogger statsLogger) {
        this.name = name;
        this.zkc = zkc;
        this.statsLogger = statsLogger;
        this.childWatches = new ConcurrentHashMap<String, Set<Watcher>>();
        this.allWatchesGauge = new AtomicInteger(0);
        this.totalWatchesGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return ZKWatcherManager.this.allWatchesGauge.get();
            }
        };
        this.statsLogger.registerGauge(totalWatchesGauageLabel, this.totalWatchesGauge);
        this.numChildWatchesGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return ZKWatcherManager.this.childWatches.size();
            }
        };
        this.statsLogger.registerGauge(numChildWatchesGauageLabel, this.numChildWatchesGauge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Watcher registerChildWatcher(String path, Watcher watcher) {
        HashSet<Watcher> watchers = (HashSet<Watcher>)this.childWatches.get(path);
        if (null == watchers) {
            HashSet newWatchers = new HashSet();
            Set oldWatchers = this.childWatches.putIfAbsent(path, newWatchers);
            watchers = null == oldWatchers ? newWatchers : oldWatchers;
        }
        HashSet<Watcher> hashSet = watchers;
        synchronized (hashSet) {
            if (this.childWatches.get(path) == watchers) {
                if (watchers.add(watcher)) {
                    this.allWatchesGauge.incrementAndGet();
                }
            } else {
                logger.warn("Watcher set for path {} has been changed while registering child watcher {}.", (Object)path, (Object)watcher);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChildWatcher(String path, Watcher watcher, boolean removeFromServer) {
        Set watchers = (Set)this.childWatches.get(path);
        if (null == watchers) {
            logger.warn("No watchers found on path {} while unregistering child watcher {}.", (Object)path, (Object)watcher);
            return;
        }
        Set set = watchers;
        synchronized (set) {
            if (watchers.remove(watcher)) {
                this.allWatchesGauge.decrementAndGet();
            } else {
                logger.warn("Remove a non-registered child watcher {} from path {}", (Object)watcher, (Object)path);
            }
            if (watchers.isEmpty()) {
                try {
                    if (null != this.zkc && removeFromServer) {
                        this.zkc.get().removeWatches(path, (Watcher)this, Watcher.WatcherType.Children, true, new AsyncCallback.VoidCallback(){

                            public void processResult(int rc, String path, Object ctx) {
                                if (KeeperException.Code.OK.intValue() == rc) {
                                    logger.debug("Successfully removed children watches from {}", (Object)path);
                                } else {
                                    logger.debug("Encountered exception on removing children watches from {}", (Object)path, (Object)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                                }
                            }
                        }, null);
                    }
                }
                catch (InterruptedException e) {
                    logger.debug("Encountered exception on removing watches from {}", (Object)path, (Object)e);
                }
                catch (ZooKeeperClient.ZooKeeperConnectionException e) {
                    logger.debug("Encountered exception on removing watches from {}", (Object)path, (Object)e);
                }
                this.childWatches.remove(path, watchers);
            }
        }
    }

    public void unregisterGauges() {
        this.statsLogger.unregisterGauge(totalWatchesGauageLabel, this.totalWatchesGauge);
        this.statsLogger.unregisterGauge(numChildWatchesGauageLabel, this.numChildWatchesGauge);
    }

    public void process(WatchedEvent event) {
        switch (event.getType()) {
            case None: {
                this.handleKeeperStateEvent(event);
                break;
            }
            case NodeChildrenChanged: {
                this.handleChildWatchEvent(event);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeeperStateEvent(WatchedEvent event) {
        HashSet savedAllWatches = new HashSet(this.allWatchesGauge.get());
        Iterator<Object> iterator = this.childWatches.values().iterator();
        while (iterator.hasNext()) {
            Set watcherSet;
            Set set = watcherSet = (Set)iterator.next();
            synchronized (set) {
                savedAllWatches.addAll(watcherSet);
            }
        }
        for (Watcher watcher : savedAllWatches) {
            watcher.process(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChildWatchEvent(WatchedEvent event) {
        HashSet watchersToFire;
        String path = event.getPath();
        if (null == path) {
            logger.warn("Received zookeeper watch event with null path : {}", (Object)event);
            return;
        }
        Set watchers = (Set)this.childWatches.get(path);
        if (null == watchers) {
            return;
        }
        Set set = watchers;
        synchronized (set) {
            watchersToFire = new HashSet(watchers.size());
            watchersToFire.addAll(watchers);
        }
        for (Watcher watcher : watchersToFire) {
            watcher.process(event);
        }
    }

    public static class Builder {
        private String _name;
        private StatsLogger _statsLogger;
        private ZooKeeperClient _zkc;

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Builder zkc(ZooKeeperClient zkc) {
            this._zkc = zkc;
            return this;
        }

        public Builder statsLogger(StatsLogger statsLogger) {
            this._statsLogger = statsLogger;
            return this;
        }

        public ZKWatcherManager build() {
            return new ZKWatcherManager(this._name, this._zkc, this._statsLogger);
        }
    }
}

