/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import org.openjdk.tools.javadoc.doclet.DocletEnvironment;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.DocType;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlDocument;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocFile;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletConstants;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class SourceToHTMLConverter {
    private static final int NUM_BLANK_LINES = 60;
    private static final String NEW_LINE = DocletConstants.NL;
    private final ConfigurationImpl configuration;
    private final Utils utils;
    private final DocletEnvironment rootDoc;
    private DocPath outputdir;
    private DocPath relativePath = DocPath.empty;

    private SourceToHTMLConverter(ConfigurationImpl configuration, DocletEnvironment rd, DocPath outputdir) {
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.rootDoc = rd;
        this.outputdir = outputdir;
    }

    public static void convertRoot(ConfigurationImpl configuration, DocletEnvironment root, DocPath outputdir) {
        new SourceToHTMLConverter(configuration, root, outputdir).generate();
    }

    void generate() {
        if (this.rootDoc == null || this.outputdir == null) {
            return;
        }
        for (PackageElement pkg : this.utils.getSpecifiedPackages()) {
            if (this.configuration.nodeprecated && this.utils.isDeprecated(pkg)) continue;
            this.convertPackage(pkg, this.outputdir);
        }
        for (TypeElement te : this.utils.getSpecifiedClasses()) {
            if (this.configuration.nodeprecated && (this.utils.isDeprecated(te) || this.utils.isDeprecated(this.utils.containingPackage(te)))) continue;
            this.convertClass(te, this.outputdir);
        }
    }

    public void convertPackage(PackageElement pkg, DocPath outputdir) {
        if (pkg == null) {
            return;
        }
        for (Element element : this.utils.getAllClasses(pkg)) {
            if (this.configuration.nodeprecated && this.utils.isDeprecated(element)) continue;
            this.convertClass((TypeElement)element, outputdir);
        }
    }

    public void convertClass(TypeElement te, DocPath outputdir) {
        if (te == null) {
            return;
        }
        try {
            FileObject fo = this.utils.getFileObject(te);
            if (fo == null) {
                return;
            }
            Reader r = fo.openReader(true);
            int lineno = 1;
            this.relativePath = DocPaths.SOURCE_OUTPUT.resolve(DocPath.forPackage(this.utils, te)).invert();
            Content body = SourceToHTMLConverter.getHeader();
            HtmlTree pre = new HtmlTree(HtmlTag.PRE);
            try (LineNumberReader reader = new LineNumberReader(r);){
                String line;
                while ((line = reader.readLine()) != null) {
                    SourceToHTMLConverter.addLineNo(pre, lineno);
                    this.addLine(pre, line, lineno);
                    ++lineno;
                }
            }
            SourceToHTMLConverter.addBlankLines(pre);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.sourceContainer, pre);
            body.addContent(this.configuration.allowTag(HtmlTag.MAIN) ? HtmlTree.MAIN(div) : div);
            this.writeToFile(body, outputdir.resolve(DocPath.forClass(this.utils, te)));
        }
        catch (IOException e) {
            throw new DocletAbortException(e);
        }
    }

    private void writeToFile(Content body, DocPath path) throws IOException {
        DocType htmlDocType = this.configuration.isOutputHtml5() ? DocType.HTML5 : DocType.TRANSITIONAL;
        HtmlTree head = new HtmlTree(HtmlTag.HEAD);
        ((Content)head).addContent(HtmlTree.TITLE(new StringContent(this.configuration.getText("doclet.Window_Source_title"))));
        ((Content)head).addContent(this.getStyleSheetProperties());
        HtmlTree htmlTree = HtmlTree.HTML(this.configuration.getLocale().getLanguage(), head, body);
        HtmlDocument htmlDocument = new HtmlDocument(htmlDocType, htmlTree);
        this.configuration.message.notice("doclet.Generating_0", path.getPath());
        DocFile df = DocFile.createFileForOutput(this.configuration, path);
        try (Writer w = df.openWriter();){
            ((Content)htmlDocument).write(w, true);
        }
    }

    public HtmlTree getStyleSheetProperties() {
        DocPath stylesheet;
        String filename = this.configuration.stylesheetfile;
        if (filename.length() > 0) {
            DocFile file = DocFile.createFileForInput(this.configuration, filename);
            stylesheet = DocPath.create(file.getName());
        } else {
            stylesheet = DocPaths.STYLESHEET;
        }
        DocPath p = this.relativePath.resolve(stylesheet);
        HtmlTree link = HtmlTree.LINK("stylesheet", "text/css", p.getPath(), "Style");
        return link;
    }

    private static Content getHeader() {
        return new HtmlTree(HtmlTag.BODY);
    }

    private static void addLineNo(Content pre, int lineno) {
        HtmlTree span = new HtmlTree(HtmlTag.SPAN);
        span.addStyle(HtmlStyle.sourceLineNo);
        if (lineno < 10) {
            span.addContent("00" + Integer.toString(lineno));
        } else if (lineno < 100) {
            span.addContent("0" + Integer.toString(lineno));
        } else {
            span.addContent(Integer.toString(lineno));
        }
        pre.addContent(span);
    }

    private void addLine(Content pre, String line, int currentLineNo) {
        if (line != null) {
            HtmlTree anchor = HtmlTree.A(this.configuration.htmlVersion, "line." + Integer.toString(currentLineNo), new StringContent(this.utils.replaceTabs(line)));
            pre.addContent(anchor);
            pre.addContent(NEW_LINE);
        }
    }

    private static void addBlankLines(Content pre) {
        for (int i = 0; i < 60; ++i) {
            pre.addContent(NEW_LINE);
        }
    }

    public static String getAnchorName(Utils utils, Element e) {
        return "line." + utils.getLineNumber(e);
    }
}

