/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.builders;

import java.io.IOException;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.ClassWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.XMLNode;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class ClassBuilder
extends AbstractBuilder {
    public static final String ROOT = "ClassDoc";
    private final TypeElement typeElement;
    private final ClassWriter writer;
    private final boolean isInterface;
    private final boolean isEnum;
    private Content contentTree;
    private final Utils utils;

    private ClassBuilder(AbstractBuilder.Context context, TypeElement typeElement, ClassWriter writer) {
        super(context);
        this.typeElement = typeElement;
        this.writer = writer;
        this.utils = this.configuration.utils;
        if (this.utils.isInterface(typeElement)) {
            this.isInterface = true;
            this.isEnum = false;
        } else if (this.utils.isEnum(typeElement)) {
            this.isInterface = false;
            this.isEnum = true;
            this.utils.setEnumDocumentation(typeElement);
        } else {
            this.isInterface = false;
            this.isEnum = false;
        }
    }

    public static ClassBuilder getInstance(AbstractBuilder.Context context, TypeElement typeElement, ClassWriter writer) {
        return new ClassBuilder(context, typeElement, writer);
    }

    @Override
    public void build() throws IOException {
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildClassDoc(XMLNode node, Content contentTree) throws Exception {
        String key = this.isInterface ? "doclet.Interface" : (this.isEnum ? "doclet.Enum" : "doclet.Class");
        contentTree = this.writer.getHeader(this.configuration.getText(key) + " " + this.utils.getSimpleName(this.typeElement));
        Content classContentTree = this.writer.getClassContentHeader();
        this.buildChildren(node, classContentTree);
        this.writer.addClassContentTree(contentTree, classContentTree);
        this.writer.addFooter(contentTree);
        this.writer.printDocument(contentTree);
        this.writer.close();
        this.copyDocFiles();
    }

    public void buildClassTree(XMLNode node, Content classContentTree) {
        this.writer.addClassTree(classContentTree);
    }

    public void buildClassInfo(XMLNode node, Content classContentTree) {
        Content classInfoTree = this.writer.getClassInfoTreeHeader();
        this.buildChildren(node, classInfoTree);
        classContentTree.addContent(this.writer.getClassInfo(classInfoTree));
    }

    public void buildTypeParamInfo(XMLNode node, Content classInfoTree) {
        this.writer.addTypeParamInfo(classInfoTree);
    }

    public void buildSuperInterfacesInfo(XMLNode node, Content classInfoTree) {
        this.writer.addSuperInterfacesInfo(classInfoTree);
    }

    public void buildImplementedInterfacesInfo(XMLNode node, Content classInfoTree) {
        this.writer.addImplementedInterfacesInfo(classInfoTree);
    }

    public void buildSubClassInfo(XMLNode node, Content classInfoTree) {
        this.writer.addSubClassInfo(classInfoTree);
    }

    public void buildSubInterfacesInfo(XMLNode node, Content classInfoTree) {
        this.writer.addSubInterfacesInfo(classInfoTree);
    }

    public void buildInterfaceUsageInfo(XMLNode node, Content classInfoTree) {
        this.writer.addInterfaceUsageInfo(classInfoTree);
    }

    public void buildFunctionalInterfaceInfo(XMLNode node, Content classInfoTree) {
        this.writer.addFunctionalInterfaceInfo(classInfoTree);
    }

    public void buildDeprecationInfo(XMLNode node, Content classInfoTree) {
        this.writer.addClassDeprecationInfo(classInfoTree);
    }

    public void buildNestedClassInfo(XMLNode node, Content classInfoTree) {
        this.writer.addNestedClassInfo(classInfoTree);
    }

    private void copyDocFiles() {
        PackageElement containingPackage = this.utils.containingPackage(this.typeElement);
        if (!(this.configuration.packages != null && this.configuration.packages.contains(containingPackage) || this.containingPackagesSeen.contains(containingPackage))) {
            this.utils.copyDocFiles(containingPackage);
            this.containingPackagesSeen.add(containingPackage);
        }
    }

    public void buildClassSignature(XMLNode node, Content classInfoTree) {
        this.writer.addClassSignature(this.utils.modifiersToString(this.typeElement, true), classInfoTree);
    }

    public void buildClassDescription(XMLNode node, Content classInfoTree) {
        this.writer.addClassDescription(classInfoTree);
    }

    public void buildClassTagInfo(XMLNode node, Content classInfoTree) {
        this.writer.addClassTagInfo(classInfoTree);
    }

    public void buildMemberSummary(XMLNode node, Content classContentTree) throws Exception {
        Content memberSummaryTree = this.writer.getMemberTreeHeader();
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).buildChildren(node, memberSummaryTree);
        classContentTree.addContent(this.writer.getMemberSummaryTree(memberSummaryTree));
    }

    public void buildMemberDetails(XMLNode node, Content classContentTree) {
        Content memberDetailsTree = this.writer.getMemberTreeHeader();
        this.buildChildren(node, memberDetailsTree);
        classContentTree.addContent(this.writer.getMemberDetailsTree(memberDetailsTree));
    }

    public void buildEnumConstantsDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getEnumConstantsBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildFieldDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getFieldBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildPropertyDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getPropertyBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildConstructorDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getConstructorBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildMethodDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getMethodBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }
}

