/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.builders;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.PackageSummaryWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.XMLNode;

public class PackageSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "PackageDoc";
    private final PackageElement packageElement;
    private final PackageSummaryWriter packageWriter;
    private Content contentTree;

    private PackageSummaryBuilder(AbstractBuilder.Context context, PackageElement pkg, PackageSummaryWriter packageWriter) {
        super(context);
        this.packageElement = pkg;
        this.packageWriter = packageWriter;
    }

    public static PackageSummaryBuilder getInstance(AbstractBuilder.Context context, PackageElement pkg, PackageSummaryWriter packageWriter) {
        return new PackageSummaryBuilder(context, pkg, packageWriter);
    }

    @Override
    public void build() throws IOException {
        if (this.packageWriter == null) {
            return;
        }
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildPackageDoc(XMLNode node, Content contentTree) throws Exception {
        contentTree = this.packageWriter.getPackageHeader(this.utils.getPackageName(this.packageElement));
        this.buildChildren(node, contentTree);
        this.packageWriter.addPackageFooter(contentTree);
        this.packageWriter.printDocument(contentTree);
        this.packageWriter.close();
        this.utils.copyDocFiles(this.packageElement);
    }

    public void buildContent(XMLNode node, Content contentTree) {
        Content packageContentTree = this.packageWriter.getContentHeader();
        this.buildChildren(node, packageContentTree);
        this.packageWriter.addPackageContent(contentTree, packageContentTree);
    }

    public void buildSummary(XMLNode node, Content packageContentTree) {
        Content summaryContentTree = this.packageWriter.getSummaryHeader();
        this.buildChildren(node, summaryContentTree);
        packageContentTree.addContent(summaryContentTree);
    }

    public void buildInterfaceSummary(XMLNode node, Content summaryContentTree) {
        String interfaceTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Interface_Summary"), this.configuration.getText("doclet.interfaces"));
        List<String> interfaceTableHeader = Arrays.asList(this.configuration.getText("doclet.Interface"), this.configuration.getText("doclet.Description"));
        SortedSet<TypeElement> ilist = this.utils.isIncluded(this.packageElement) ? this.utils.getTypeElementsAsSortedSet(this.utils.getInterfaces(this.packageElement)) : this.configuration.typeElementCatalog.interfaces(this.packageElement);
        SortedSet<TypeElement> interfaces = this.utils.filterOutPrivateClasses(ilist, this.configuration.javafx);
        if (!interfaces.isEmpty()) {
            this.packageWriter.addClassesSummary(interfaces, this.configuration.getText("doclet.Interface_Summary"), interfaceTableSummary, interfaceTableHeader, summaryContentTree);
        }
    }

    public void buildClassSummary(XMLNode node, Content summaryContentTree) {
        String classTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Class_Summary"), this.configuration.getText("doclet.classes"));
        List<String> classTableHeader = Arrays.asList(this.configuration.getText("doclet.Class"), this.configuration.getText("doclet.Description"));
        SortedSet<TypeElement> clist = this.utils.isIncluded(this.packageElement) ? this.utils.getTypeElementsAsSortedSet(this.utils.getOrdinaryClasses(this.packageElement)) : this.configuration.typeElementCatalog.ordinaryClasses(this.packageElement);
        SortedSet<TypeElement> classes = this.utils.filterOutPrivateClasses(clist, this.configuration.javafx);
        if (!classes.isEmpty()) {
            this.packageWriter.addClassesSummary(classes, this.configuration.getText("doclet.Class_Summary"), classTableSummary, classTableHeader, summaryContentTree);
        }
    }

    public void buildEnumSummary(XMLNode node, Content summaryContentTree) {
        String enumTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Enum_Summary"), this.configuration.getText("doclet.enums"));
        List<String> enumTableHeader = Arrays.asList(this.configuration.getText("doclet.Enum"), this.configuration.getText("doclet.Description"));
        SortedSet<TypeElement> elist = this.utils.isIncluded(this.packageElement) ? this.utils.getTypeElementsAsSortedSet(this.utils.getEnums(this.packageElement)) : this.configuration.typeElementCatalog.enums(this.packageElement);
        SortedSet<TypeElement> enums = this.utils.filterOutPrivateClasses(elist, this.configuration.javafx);
        if (!enums.isEmpty()) {
            this.packageWriter.addClassesSummary(enums, this.configuration.getText("doclet.Enum_Summary"), enumTableSummary, enumTableHeader, summaryContentTree);
        }
    }

    public void buildExceptionSummary(XMLNode node, Content summaryContentTree) {
        String exceptionTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Exception_Summary"), this.configuration.getText("doclet.exceptions"));
        List<String> exceptionTableHeader = Arrays.asList(this.configuration.getText("doclet.Exception"), this.configuration.getText("doclet.Description"));
        SortedSet<TypeElement> iexceptions = this.utils.isIncluded(this.packageElement) ? this.utils.getTypeElementsAsSortedSet(this.utils.getExceptions(this.packageElement)) : this.configuration.typeElementCatalog.exceptions(this.packageElement);
        SortedSet<TypeElement> exceptions = this.utils.filterOutPrivateClasses(iexceptions, this.configuration.javafx);
        if (!exceptions.isEmpty()) {
            this.packageWriter.addClassesSummary(exceptions, this.configuration.getText("doclet.Exception_Summary"), exceptionTableSummary, exceptionTableHeader, summaryContentTree);
        }
    }

    public void buildErrorSummary(XMLNode node, Content summaryContentTree) {
        String errorTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Error_Summary"), this.configuration.getText("doclet.errors"));
        List<String> errorTableHeader = Arrays.asList(this.configuration.getText("doclet.Error"), this.configuration.getText("doclet.Description"));
        SortedSet<TypeElement> ierrors = this.utils.isIncluded(this.packageElement) ? this.utils.getTypeElementsAsSortedSet(this.utils.getErrors(this.packageElement)) : this.configuration.typeElementCatalog.errors(this.packageElement);
        SortedSet<TypeElement> errors = this.utils.filterOutPrivateClasses(ierrors, this.configuration.javafx);
        if (!errors.isEmpty()) {
            this.packageWriter.addClassesSummary(errors, this.configuration.getText("doclet.Error_Summary"), errorTableSummary, errorTableHeader, summaryContentTree);
        }
    }

    public void buildAnnotationTypeSummary(XMLNode node, Content summaryContentTree) {
        String annotationtypeTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Annotation_Types_Summary"), this.configuration.getText("doclet.annotationtypes"));
        List<String> annotationtypeTableHeader = Arrays.asList(this.configuration.getText("doclet.AnnotationType"), this.configuration.getText("doclet.Description"));
        SortedSet<TypeElement> iannotationTypes = this.utils.isIncluded(this.packageElement) ? this.utils.getTypeElementsAsSortedSet(this.utils.getAnnotationTypes(this.packageElement)) : this.configuration.typeElementCatalog.annotationTypes(this.packageElement);
        SortedSet<TypeElement> annotationTypes = this.utils.filterOutPrivateClasses(iannotationTypes, this.configuration.javafx);
        if (!annotationTypes.isEmpty()) {
            this.packageWriter.addClassesSummary(annotationTypes, this.configuration.getText("doclet.Annotation_Types_Summary"), annotationtypeTableSummary, annotationtypeTableHeader, summaryContentTree);
        }
    }

    public void buildPackageDescription(XMLNode node, Content packageContentTree) {
        if (this.configuration.nocomment) {
            return;
        }
        this.packageWriter.addPackageDescription(packageContentTree);
    }

    public void buildPackageTags(XMLNode node, Content packageContentTree) {
        if (this.configuration.nocomment) {
            return;
        }
        this.packageWriter.addPackageTags(packageContentTree);
    }
}

