/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocLink;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class DocPath {
    private final String path;
    public static final DocPath empty = new DocPath("");
    public static final DocPath parent = new DocPath("..");

    public static DocPath create(String p) {
        return p == null || p.isEmpty() ? empty : new DocPath(p);
    }

    public static DocPath forClass(Utils utils, TypeElement typeElement) {
        return typeElement == null ? empty : DocPath.forPackage(utils.containingPackage(typeElement)).resolve(DocPath.forName(utils, typeElement));
    }

    public static DocPath forName(Utils utils, TypeElement typeElement) {
        return typeElement == null ? empty : new DocPath(utils.getSimpleName(typeElement) + ".html");
    }

    public static DocPath forPackage(Utils utils, TypeElement typeElement) {
        return typeElement == null ? empty : DocPath.forPackage(utils.containingPackage(typeElement));
    }

    public static DocPath forPackage(PackageElement pkgElement) {
        return pkgElement == null || pkgElement.isUnnamed() ? empty : DocPath.create(pkgElement.getQualifiedName().toString().replace('.', '/'));
    }

    public static DocPath forRoot(PackageElement pkgElement) {
        String name = pkgElement == null || pkgElement.isUnnamed() ? "" : pkgElement.getQualifiedName().toString();
        return new DocPath(name.replace('.', '/').replaceAll("[^/]+", ".."));
    }

    public static DocPath relativePath(PackageElement from, PackageElement to) {
        return DocPath.forRoot(from).resolve(DocPath.forPackage(to));
    }

    protected DocPath(String p) {
        this.path = p.endsWith("/") ? p.substring(0, p.length() - 1) : p;
    }

    public boolean equals(Object other) {
        return other instanceof DocPath && this.path.equals(((DocPath)other).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public DocPath basename() {
        int sep = this.path.lastIndexOf("/");
        return sep == -1 ? this : new DocPath(this.path.substring(sep + 1));
    }

    public DocPath parent() {
        int sep = this.path.lastIndexOf("/");
        return sep == -1 ? empty : new DocPath(this.path.substring(0, sep));
    }

    public DocPath resolve(String p) {
        if (p == null || p.isEmpty()) {
            return this;
        }
        if (this.path.isEmpty()) {
            return new DocPath(p);
        }
        return new DocPath(this.path + "/" + p);
    }

    public DocPath resolve(DocPath p) {
        if (p == null || p.isEmpty()) {
            return this;
        }
        if (this.path.isEmpty()) {
            return p;
        }
        return new DocPath(this.path + "/" + p.getPath());
    }

    public DocPath invert() {
        return new DocPath(this.path.replaceAll("[^/]+", ".."));
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public DocLink fragment(String fragment) {
        return new DocLink(this.path, null, fragment);
    }

    public DocLink query(String query) {
        return new DocLink(this.path, query, null);
    }

    public String getPath() {
        return this.path;
    }
}

