/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.javadoc.JavadocFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class JavaCommentsHelper
implements CommentsHelper {
    private final JavaFormatterOptions options;
    private final String lineSeparator;

    public JavaCommentsHelper(String lineSeparator, JavaFormatterOptions options) {
        this.lineSeparator = lineSeparator;
        this.options = options;
    }

    @Override
    public String rewrite(Input.Tok tok, int maxWidth, int column0) {
        if (!tok.isComment()) {
            return tok.getOriginalText();
        }
        String text = tok.getOriginalText();
        if (tok.isJavadocComment()) {
            text = JavadocFormatter.formatJavadoc(text, column0, this.options);
        }
        ArrayList<String> lines = new ArrayList<String>();
        Iterator<String> it = Newlines.lineIterator(text);
        while (it.hasNext()) {
            lines.add(CharMatcher.whitespace().trimTrailingFrom((CharSequence)it.next()));
        }
        if (tok.isSlashSlashComment()) {
            return this.indentLineComments(lines, column0);
        }
        if (JavaCommentsHelper.javadocShaped(lines)) {
            return this.indentJavadoc(lines, column0);
        }
        return this.preserveIndentation(lines, column0);
    }

    private String preserveIndentation(List<String> lines, int column0) {
        int i;
        StringBuilder builder = new StringBuilder();
        int startCol = -1;
        for (i = 1; i < lines.size(); ++i) {
            int lineIdx = CharMatcher.whitespace().negate().indexIn((CharSequence)lines.get(i));
            if (lineIdx < 0 || startCol != -1 && lineIdx >= startCol) continue;
            startCol = lineIdx;
        }
        builder.append(lines.get(0));
        for (i = 1; i < lines.size(); ++i) {
            builder.append(this.lineSeparator).append(Strings.repeat((String)" ", (int)column0));
            if (lines.get(i).length() >= startCol) {
                builder.append(lines.get(i).substring(startCol));
                continue;
            }
            builder.append(lines.get(i));
        }
        return builder.toString();
    }

    private String indentLineComments(List<String> lines, int column0) {
        StringBuilder builder = new StringBuilder();
        builder.append(lines.get(0).trim());
        String indentString = Strings.repeat((String)" ", (int)column0);
        for (int i = 1; i < lines.size(); ++i) {
            builder.append(this.lineSeparator).append(indentString).append(lines.get(i).trim());
        }
        return builder.toString();
    }

    private String indentJavadoc(List<String> lines, int column0) {
        StringBuilder builder = new StringBuilder();
        builder.append(lines.get(0).trim());
        int indent = column0 + 1;
        String indentString = Strings.repeat((String)" ", (int)indent);
        for (int i = 1; i < lines.size(); ++i) {
            builder.append(this.lineSeparator).append(indentString);
            String line = lines.get(i).trim();
            if (!line.startsWith("*")) {
                builder.append("* ");
            }
            builder.append(line);
        }
        return builder.toString();
    }

    private static boolean javadocShaped(List<String> lines) {
        Iterator<String> it = lines.iterator();
        if (!it.hasNext()) {
            return false;
        }
        String first = it.next().trim();
        if (first.startsWith("/**")) {
            return true;
        }
        if (!first.startsWith("/*")) {
            return false;
        }
        while (it.hasNext()) {
            if (it.next().trim().startsWith("*")) continue;
            return false;
        }
        return true;
    }
}

