/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.apache.commons.lang.StringUtils;

public final class MorePreconditions {
    private static final String ARG_NOT_BLANK_MSG = "Argument cannot be blank";

    private MorePreconditions() {
    }

    public static String checkNotBlank(String argument) {
        return MorePreconditions.checkNotBlank(argument, ARG_NOT_BLANK_MSG, new Object[0]);
    }

    public static String checkNotBlank(String argument, String message, Object ... args) {
        Preconditions.checkNotNull((Object)argument, (String)message, (Object[])args);
        Preconditions.checkArgument((!StringUtils.isBlank((String)argument) ? 1 : 0) != 0, (String)message, (Object[])args);
        return argument;
    }

    public static <S, T extends Iterable<S>> T checkNotBlank(T argument) {
        return MorePreconditions.checkNotBlank(argument, ARG_NOT_BLANK_MSG, new Object[0]);
    }

    public static <S, T extends Iterable<S>> T checkNotBlank(T argument, String message, Object ... args) {
        Preconditions.checkNotNull(argument, (String)message, (Object[])args);
        Preconditions.checkArgument((!Iterables.isEmpty(argument) ? 1 : 0) != 0, (String)message, (Object[])args);
        return argument;
    }

    public static double checkArgumentRange(double argument, double minimum, double maximum, String message) {
        Preconditions.checkArgument((minimum <= argument ? 1 : 0) != 0, (String)message, (Object[])new Object[]{argument});
        Preconditions.checkArgument((argument <= maximum ? 1 : 0) != 0, (String)message, (Object[])new Object[]{argument});
        return argument;
    }

    public static int checkArgumentRange(int argument, int minimum, int maximum, String message) {
        Preconditions.checkArgument((minimum <= argument ? 1 : 0) != 0, (String)message, (Object[])new Object[]{argument});
        Preconditions.checkArgument((argument <= maximum ? 1 : 0) != 0, (String)message, (Object[])new Object[]{argument});
        return argument;
    }

    public static boolean checkArguments(String message, Boolean ... arguments) {
        for (Boolean argument : arguments) {
            if (!argument.booleanValue()) continue;
            return true;
        }
        throw new IllegalArgumentException(message);
    }
}

