/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.stats;

import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.distributedlog.thrift.service.StatusCode;

public class ClientStatsLogger {
    private final StatsReceiver statsReceiver;
    private final StatsReceiver responseStatsReceiver;
    private final ConcurrentMap<StatusCode, Counter> responseStats = new ConcurrentHashMap<StatusCode, Counter>();
    private final StatsReceiver exceptionStatsReceiver;
    private final ConcurrentMap<Class<?>, Counter> exceptionStats = new ConcurrentHashMap();
    private final Stat proxySuccessLatencyStat;
    private final Stat proxyFailureLatencyStat;

    public ClientStatsLogger(StatsReceiver statsReceiver) {
        this.statsReceiver = statsReceiver;
        this.responseStatsReceiver = statsReceiver.scope("responses");
        this.exceptionStatsReceiver = statsReceiver.scope("exceptions");
        StatsReceiver proxyLatencyStatReceiver = statsReceiver.scope("proxy_request_latency");
        this.proxySuccessLatencyStat = proxyLatencyStatReceiver.stat0("success");
        this.proxyFailureLatencyStat = proxyLatencyStatReceiver.stat0("failure");
    }

    public StatsReceiver getStatsReceiver() {
        return this.statsReceiver;
    }

    private Counter getResponseCounter(StatusCode code) {
        Counter counter = (Counter)this.responseStats.get(code);
        if (null == counter) {
            Counter newCounter = this.responseStatsReceiver.counter0(code.name());
            Counter oldCounter = this.responseStats.putIfAbsent(code, newCounter);
            counter = null != oldCounter ? oldCounter : newCounter;
        }
        return counter;
    }

    private Counter getExceptionCounter(Class<?> cls) {
        Counter counter = (Counter)this.exceptionStats.get(cls);
        if (null == counter) {
            Counter newCounter = this.exceptionStatsReceiver.counter0(cls.getName());
            Counter oldCounter = this.exceptionStats.putIfAbsent(cls, newCounter);
            counter = null != oldCounter ? oldCounter : newCounter;
        }
        return counter;
    }

    public void completeProxyRequest(StatusCode code, long startTimeNanos) {
        this.getResponseCounter(code).incr();
        this.proxySuccessLatencyStat.add((float)ClientStatsLogger.elapsedMicroSec(startTimeNanos));
    }

    public void failProxyRequest(Throwable cause, long startTimeNanos) {
        this.getExceptionCounter(cause.getClass()).incr();
        this.proxyFailureLatencyStat.add((float)ClientStatsLogger.elapsedMicroSec(startTimeNanos));
    }

    static long elapsedMicroSec(long startNanoTime) {
        return TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startNanoTime);
    }
}

