/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Ticker;
import com.twitter.common.collections.Pair;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.stats.SampledStat;
import com.twitter.common.stats.Stat;
import com.twitter.common.stats.Stats;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Rate<T extends Number>
extends SampledStat<Double> {
    private static final int DEFAULT_WINDOW_SIZE = 1;
    private static final double DEFAULT_SCALE_FACTOR = 1.0;
    private static final long NANOS_PER_SEC = (Long)Amount.of((long)1L, (Unit)Time.SECONDS).as((Unit)Time.NANOSECONDS);
    private final Supplier<T> inputAccessor;
    private final Ticker ticker;
    private final double scaleFactor;
    private final LinkedBlockingDeque<Pair<Long, Double>> samples;

    private Rate(String name, Supplier<T> inputAccessor, int windowSize, double scaleFactor, Ticker ticker) {
        super(name, 0.0);
        this.inputAccessor = (Supplier)Preconditions.checkNotNull(inputAccessor);
        this.ticker = (Ticker)Preconditions.checkNotNull((Object)ticker);
        this.samples = new LinkedBlockingDeque(windowSize);
        Preconditions.checkArgument((scaleFactor != 0.0 ? 1 : 0) != 0, (Object)"Scale factor must be non-zero!");
        this.scaleFactor = scaleFactor;
    }

    public static <T extends Number> Builder<T> of(Stat<T> input) {
        return new Builder<T>(input);
    }

    public static Builder<Long> of(String name, Supplier<Long> input) {
        return new Builder<Long>(name, input);
    }

    public static Builder<AtomicInteger> of(String name, AtomicInteger input) {
        return new Builder<AtomicInteger>(name, input);
    }

    public static Builder<AtomicLong> of(String name, AtomicLong input) {
        return new Builder<AtomicLong>(name, input);
    }

    @Override
    public Double doSample() {
        Number newSample = (Number)this.inputAccessor.get();
        long newTimestamp = this.ticker.read();
        double rate = 0.0;
        if (!this.samples.isEmpty()) {
            Pair<Long, Double> oldestSample = this.samples.peekLast();
            double dy = newSample.doubleValue() - (Double)oldestSample.getSecond();
            double dt = newTimestamp - (Long)oldestSample.getFirst();
            double d = rate = dt == 0.0 ? 0.0 : (double)NANOS_PER_SEC * this.scaleFactor * dy / dt;
        }
        if (this.samples.remainingCapacity() == 0) {
            this.samples.removeLast();
        }
        this.samples.addFirst((Pair<Long, Double>)Pair.of((Object)newTimestamp, (Object)newSample.doubleValue()));
        return rate;
    }

    public static class Builder<T extends Number> {
        private String name;
        private int windowSize = 1;
        private double scaleFactor = 1.0;
        private Supplier<T> inputAccessor;
        private Ticker ticker = Ticker.systemTicker();

        Builder(String name, T input) {
            this.name = name;
            this.inputAccessor = Suppliers.ofInstance(input);
        }

        Builder(String name, Supplier<T> input) {
            this.name = name;
            this.inputAccessor = input;
        }

        Builder(final Stat<T> input) {
            Stats.export(input);
            this.name = input.getName() + "_per_sec";
            this.inputAccessor = new Supplier<T>(){

                public T get() {
                    return (Number)input.read();
                }
            };
        }

        public Builder<T> withName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> withWindowSize(int windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public Builder<T> withScaleFactor(double scaleFactor) {
            this.scaleFactor = scaleFactor;
            return this;
        }

        @VisibleForTesting
        Builder<T> withTicker(Ticker ticker) {
            this.ticker = ticker;
            return this;
        }

        public Rate<T> build() {
            return new Rate(this.name, this.inputAccessor, this.windowSize, this.scaleFactor, this.ticker);
        }
    }
}

