/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageFluent;
import io.fabric8.openshift.api.model.ImageLayer;
import io.fabric8.openshift.api.model.ImageLayerBuilder;
import io.fabric8.openshift.api.model.ImageLayerFluentImpl;
import io.fabric8.openshift.api.model.ImageSignature;
import io.fabric8.openshift.api.model.ImageSignatureBuilder;
import io.fabric8.openshift.api.model.ImageSignatureFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ImageFluentImpl<A extends ImageFluent<A>>
extends BaseFluent<A>
implements ImageFluent<A> {
    private String apiVersion;
    private String dockerImageConfig;
    private List<VisitableBuilder<? extends ImageLayer, ?>> dockerImageLayers = new ArrayList();
    private String dockerImageManifest;
    private String dockerImageManifestMediaType;
    private String dockerImageMetadataVersion;
    private String dockerImageReference;
    private List<String> dockerImageSignatures = new ArrayList<String>();
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private List<VisitableBuilder<? extends ImageSignature, ?>> signatures = new ArrayList();

    public ImageFluentImpl() {
    }

    public ImageFluentImpl(Image instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDockerImageConfig(instance.getDockerImageConfig());
        this.withDockerImageLayers(instance.getDockerImageLayers());
        this.withDockerImageManifest(instance.getDockerImageManifest());
        this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
        this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
        this.withDockerImageReference(instance.getDockerImageReference());
        this.withDockerImageSignatures(instance.getDockerImageSignatures());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSignatures(instance.getSignatures());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getDockerImageConfig() {
        return this.dockerImageConfig;
    }

    @Override
    public A withDockerImageConfig(String dockerImageConfig) {
        this.dockerImageConfig = dockerImageConfig;
        return (A)this;
    }

    @Override
    public A addToDockerImageLayers(ImageLayer ... items) {
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.add(builder);
            this.dockerImageLayers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDockerImageLayers(ImageLayer ... items) {
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.remove(builder);
            this.dockerImageLayers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ImageLayer> getDockerImageLayers() {
        return ImageFluentImpl.build(this.dockerImageLayers);
    }

    @Override
    public A withDockerImageLayers(List<ImageLayer> dockerImageLayers) {
        this._visitables.removeAll(this.dockerImageLayers);
        this.dockerImageLayers.clear();
        if (dockerImageLayers != null) {
            for (ImageLayer item : dockerImageLayers) {
                this.addToDockerImageLayers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDockerImageLayers(ImageLayer ... dockerImageLayers) {
        this.dockerImageLayers.clear();
        if (dockerImageLayers != null) {
            for (ImageLayer item : dockerImageLayers) {
                this.addToDockerImageLayers(item);
            }
        }
        return (A)this;
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer() {
        return new DockerImageLayersNestedImpl();
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item) {
        return new DockerImageLayersNestedImpl(item);
    }

    @Override
    public A addNewDockerImageLayer(String mediaType, String name, Long size) {
        return this.addToDockerImageLayers(new ImageLayer(mediaType, name, size));
    }

    @Override
    public String getDockerImageManifest() {
        return this.dockerImageManifest;
    }

    @Override
    public A withDockerImageManifest(String dockerImageManifest) {
        this.dockerImageManifest = dockerImageManifest;
        return (A)this;
    }

    @Override
    public String getDockerImageManifestMediaType() {
        return this.dockerImageManifestMediaType;
    }

    @Override
    public A withDockerImageManifestMediaType(String dockerImageManifestMediaType) {
        this.dockerImageManifestMediaType = dockerImageManifestMediaType;
        return (A)this;
    }

    @Override
    public String getDockerImageMetadataVersion() {
        return this.dockerImageMetadataVersion;
    }

    @Override
    public A withDockerImageMetadataVersion(String dockerImageMetadataVersion) {
        this.dockerImageMetadataVersion = dockerImageMetadataVersion;
        return (A)this;
    }

    @Override
    public String getDockerImageReference() {
        return this.dockerImageReference;
    }

    @Override
    public A withDockerImageReference(String dockerImageReference) {
        this.dockerImageReference = dockerImageReference;
        return (A)this;
    }

    @Override
    public A addToDockerImageSignatures(String ... items) {
        for (String item : items) {
            this.dockerImageSignatures.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDockerImageSignatures(String ... items) {
        for (String item : items) {
            this.dockerImageSignatures.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDockerImageSignatures() {
        return this.dockerImageSignatures;
    }

    @Override
    public A withDockerImageSignatures(List<String> dockerImageSignatures) {
        this.dockerImageSignatures.clear();
        if (dockerImageSignatures != null) {
            for (String item : dockerImageSignatures) {
                this.addToDockerImageSignatures(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDockerImageSignatures(String ... dockerImageSignatures) {
        this.dockerImageSignatures.clear();
        if (dockerImageSignatures != null) {
            for (String item : dockerImageSignatures) {
                this.addToDockerImageSignatures(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ImageFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ImageFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ImageFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToSignatures(ImageSignature ... items) {
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.add(builder);
            this.signatures.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSignatures(ImageSignature ... items) {
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.remove(builder);
            this.signatures.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ImageSignature> getSignatures() {
        return ImageFluentImpl.build(this.signatures);
    }

    @Override
    public A withSignatures(List<ImageSignature> signatures) {
        this._visitables.removeAll(this.signatures);
        this.signatures.clear();
        if (signatures != null) {
            for (ImageSignature item : signatures) {
                this.addToSignatures(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSignatures(ImageSignature ... signatures) {
        this.signatures.clear();
        if (signatures != null) {
            for (ImageSignature item : signatures) {
                this.addToSignatures(item);
            }
        }
        return (A)this;
    }

    @Override
    public ImageFluent.SignaturesNested<A> addNewSignature() {
        return new SignaturesNestedImpl();
    }

    @Override
    public ImageFluent.SignaturesNested<A> addNewSignatureLike(ImageSignature item) {
        return new SignaturesNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageFluentImpl that = (ImageFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.dockerImageConfig != null ? !this.dockerImageConfig.equals(that.dockerImageConfig) : that.dockerImageConfig != null) {
            return false;
        }
        if (this.dockerImageLayers != null ? !this.dockerImageLayers.equals(that.dockerImageLayers) : that.dockerImageLayers != null) {
            return false;
        }
        if (this.dockerImageManifest != null ? !this.dockerImageManifest.equals(that.dockerImageManifest) : that.dockerImageManifest != null) {
            return false;
        }
        if (this.dockerImageManifestMediaType != null ? !this.dockerImageManifestMediaType.equals(that.dockerImageManifestMediaType) : that.dockerImageManifestMediaType != null) {
            return false;
        }
        if (this.dockerImageMetadataVersion != null ? !this.dockerImageMetadataVersion.equals(that.dockerImageMetadataVersion) : that.dockerImageMetadataVersion != null) {
            return false;
        }
        if (this.dockerImageReference != null ? !this.dockerImageReference.equals(that.dockerImageReference) : that.dockerImageReference != null) {
            return false;
        }
        if (this.dockerImageSignatures != null ? !this.dockerImageSignatures.equals(that.dockerImageSignatures) : that.dockerImageSignatures != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.signatures != null ? !this.signatures.equals(that.signatures) : that.signatures != null);
    }

    public class SignaturesNestedImpl<N>
    extends ImageSignatureFluentImpl<ImageFluent.SignaturesNested<N>>
    implements ImageFluent.SignaturesNested<N>,
    Nested<N> {
        private final ImageSignatureBuilder builder;

        SignaturesNestedImpl(ImageSignature item) {
            this.builder = new ImageSignatureBuilder(this, item);
        }

        SignaturesNestedImpl() {
            this.builder = new ImageSignatureBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.addToSignatures(this.builder.build());
        }

        @Override
        public N endSignature() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ImageFluent.MetadataNested<N>>
    implements ImageFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class DockerImageLayersNestedImpl<N>
    extends ImageLayerFluentImpl<ImageFluent.DockerImageLayersNested<N>>
    implements ImageFluent.DockerImageLayersNested<N>,
    Nested<N> {
        private final ImageLayerBuilder builder;

        DockerImageLayersNestedImpl(ImageLayer item) {
            this.builder = new ImageLayerBuilder(this, item);
        }

        DockerImageLayersNestedImpl() {
            this.builder = new ImageLayerBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.addToDockerImageLayers(this.builder.build());
        }

        @Override
        public N endDockerImageLayer() {
            return this.and();
        }
    }
}

