/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.rebind.RebindContext;
import org.apache.brooklyn.api.mgmt.rebind.RebindExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.rebind.RebindContextLookupContext;
import org.apache.brooklyn.util.collections.MutableMap;
import org.osgi.framework.BundleException;

public class RebindContextImpl
implements RebindContext {
    private final Map<String, Entity> entities = Maps.newLinkedHashMap();
    private final Map<String, Location> locations = Maps.newLinkedHashMap();
    private final Map<String, Policy> policies = Maps.newLinkedHashMap();
    private final Map<String, Enricher> enrichers = Maps.newLinkedHashMap();
    private final Map<String, Feed> feeds = Maps.newLinkedHashMap();
    private final Map<String, CatalogItem<?, ?>> catalogItems = Maps.newLinkedHashMap();
    private final Map<String, ManagedBundle> bundles = Maps.newLinkedHashMap();
    private final ClassLoader classLoader;
    private final ManagementContext mgmt;
    private final RebindExceptionHandler exceptionHandler;
    private final BrooklynMementoPersister.LookupContext lookupContext;
    private boolean allAreReadOnly = false;

    public RebindContextImpl(ManagementContext mgmt, RebindExceptionHandler exceptionHandler, ClassLoader classLoader) {
        this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
        this.exceptionHandler = (RebindExceptionHandler)Preconditions.checkNotNull((Object)exceptionHandler, (Object)"exceptionHandler");
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
        this.lookupContext = new RebindContextLookupContext("root-rebind-context", mgmt, this, exceptionHandler);
    }

    public void registerEntity(String id, Entity entity) {
        this.entities.put(id, entity);
    }

    public void registerLocation(String id, Location location) {
        this.locations.put(id, location);
    }

    public void registerPolicy(String id, Policy policy) {
        this.policies.put(id, policy);
    }

    public void registerEnricher(String id, Enricher enricher) {
        this.enrichers.put(id, enricher);
    }

    public void registerFeed(String id, Feed feed) {
        this.feeds.put(id, feed);
    }

    public void registerCatalogItem(String id, CatalogItem<?, ?> catalogItem) {
        this.catalogItems.put(id, catalogItem);
    }

    public OsgiBundleInstallationResult installBundle(ManagedBundle bundle, InputStream zipInput) {
        return (OsgiBundleInstallationResult)((OsgiManager)((ManagementContextInternal)this.mgmt).getOsgiManager().get()).installDeferredStart(bundle, zipInput, false).get();
    }

    public void startBundle(OsgiBundleInstallationResult br) throws BundleException {
        if (br.getDeferredStart() != null) {
            br.getDeferredStart().run();
        }
    }

    public void unregisterPolicy(Policy policy) {
        this.policies.remove(policy.getId());
    }

    public void unregisterEnricher(Enricher enricher) {
        this.enrichers.remove(enricher.getId());
    }

    public void unregisterFeed(Feed feed) {
        this.feeds.remove(feed.getId());
    }

    public void unregisterCatalogItem(CatalogItem<?, ?> item) {
        this.catalogItems.remove(item.getId());
    }

    public void clearCatalogItems() {
        this.catalogItems.clear();
    }

    public Entity getEntity(String id) {
        return this.entities.get(id);
    }

    public Location getLocation(String id) {
        return this.locations.get(id);
    }

    public Policy getPolicy(String id) {
        return this.policies.get(id);
    }

    public Enricher getEnricher(String id) {
        return this.enrichers.get(id);
    }

    public Feed getFeed(String id) {
        return this.feeds.get(id);
    }

    public CatalogItem<?, ?> getCatalogItem(String id) {
        return this.catalogItems.get(id);
    }

    public ManagedBundle getBundle(String id) {
        return this.bundles.get(id);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    public RebindExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public Collection<Location> getLocations() {
        return this.locations.values();
    }

    public Collection<Entity> getEntities() {
        return this.entities.values();
    }

    public Collection<Policy> getPolicies() {
        return this.policies.values();
    }

    public Collection<Enricher> getEnrichers() {
        return this.enrichers.values();
    }

    public Collection<Feed> getFeeds() {
        return this.feeds.values();
    }

    public Collection<CatalogItem<?, ?>> getCatalogItems() {
        return this.catalogItems.values();
    }

    public Collection<ManagedBundle> getBundles() {
        return this.bundles.values();
    }

    public Map<String, BrooklynObject> getAllBrooklynObjects() {
        MutableMap result = MutableMap.of();
        result.putAll(this.locations);
        result.putAll(this.entities);
        result.putAll(this.policies);
        result.putAll(this.enrichers);
        result.putAll(this.feeds);
        result.putAll(this.catalogItems);
        result.putAll(this.bundles);
        return result.asUnmodifiable();
    }

    public void setAllReadOnly() {
        this.allAreReadOnly = true;
    }

    public boolean isReadOnly(BrooklynObject item) {
        return this.allAreReadOnly;
    }

    public BrooklynMementoPersister.LookupContext lookup() {
        return this.lookupContext;
    }
}

