/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind.dto;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.rebind.mementos.CatalogItemMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EnricherMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EntityMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.FeedMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.LocationMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.ManagedBundleMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.PolicyMemento;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.relations.RelationshipType;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.catalog.internal.CatalogItemDo;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.EntityDynamicType;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.mgmt.rebind.dto.AbstractMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicCatalogItemMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicEnricherMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicEntityMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicFeedMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicLocationMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicManagedBundleMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicPolicyMemento;
import org.apache.brooklyn.core.objs.BrooklynTypes;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.xstream.OsgiClassPrefixer;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MementosGenerators {
    private static final Logger log = LoggerFactory.getLogger(MementosGenerators.class);
    private static Set<String> WARNED_ON_PERSISTING_TASK_CONFIG = MutableSet.of();

    private MementosGenerators() {
    }

    @Beta
    public static Memento newBasicMemento(BrooklynObject instance) {
        if (instance instanceof Entity) {
            return MementosGenerators.newEntityMemento((Entity)instance);
        }
        if (instance instanceof Location) {
            return MementosGenerators.newLocationMemento((Location)instance);
        }
        if (instance instanceof Policy) {
            return MementosGenerators.newPolicyMemento((Policy)instance);
        }
        if (instance instanceof Enricher) {
            return MementosGenerators.newEnricherMemento((Enricher)instance);
        }
        if (instance instanceof Feed) {
            return MementosGenerators.newFeedMemento((Feed)instance);
        }
        if (instance instanceof CatalogItem) {
            return MementosGenerators.newCatalogItemMemento((CatalogItem)instance);
        }
        if (instance instanceof ManagedBundle) {
            return MementosGenerators.newManagedBundleMemento((ManagedBundle)instance);
        }
        throw new IllegalArgumentException("Unexpected brooklyn type: " + (instance == null ? "null" : instance.getClass()) + " (" + instance + ")");
    }

    private static EntityMemento newEntityMemento(Entity entityRaw) {
        EntityInternal entity = (EntityInternal)entityRaw;
        BasicEntityMemento.Builder builder = BasicEntityMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder(entity, builder);
        EntityDynamicType definedType = BrooklynTypes.getDefinedEntityType(entity.getClass());
        builder.effectors.addAll(entity.getEntityType().getEffectors());
        builder.effectors.removeAll(definedType.getEffectors().values());
        builder.isTopLevelApp = entity instanceof Application && entity.getParent() == null;
        builder.configKeys.addAll(entity.getEntityType().getConfigKeys());
        Map<ConfigKey<?>, Object> localConfig = entity.config().getAllLocalRaw();
        for (Map.Entry<ConfigKey<?>, Object> entry : localConfig.entrySet()) {
            ConfigKey configKey = (ConfigKey)Preconditions.checkNotNull(entry.getKey(), localConfig);
            Object object = MementosGenerators.configValueToPersistable(entry.getValue(), (BrooklynObject)entityRaw, configKey.getName());
            builder.config.put(configKey, object);
        }
        MutableMap localConfigUnmatched = MutableMap.copyOf(entity.config().getLocalBag().getAllConfig());
        for (ConfigKey<?> configKey : localConfig.keySet()) {
            localConfigUnmatched.remove(configKey.getName());
        }
        for (Map.Entry entry : localConfigUnmatched.entrySet()) {
            String string = (String)Preconditions.checkNotNull(entry.getKey(), localConfig);
            Object value = entry.getValue();
            builder.configUnmatched.put(string, value);
        }
        Map map = entity.sensors().getAll();
        for (Map.Entry entry : map.entrySet()) {
            AttributeSensor key = (AttributeSensor)Preconditions.checkNotNull(entry.getKey(), (Object)map);
            if (key.getPersistenceMode() == AttributeSensor.SensorPersistenceMode.NONE) continue;
            Object value = entry.getValue();
            builder.attributes.put(key, value);
        }
        for (Location location : entity.getLocations()) {
            builder.locations.add(location.getId());
        }
        for (Entity entity2 : entity.getChildren()) {
            builder.children.add(entity2.getId());
        }
        Iterator iterator = entity.policies().iterator();
        while (iterator.hasNext()) {
            Policy policy = (Policy)iterator.next();
            builder.policies.add(policy.getId());
        }
        Iterator iterator2 = entity.enrichers().iterator();
        while (iterator2.hasNext()) {
            Enricher enricher = (Enricher)iterator2.next();
            builder.enrichers.add(enricher.getId());
        }
        for (Feed feed : entity.feeds().getFeeds()) {
            builder.feeds.add(feed.getId());
        }
        Entity entity3 = entity.getParent();
        String string = builder.parent = entity3 != null ? entity3.getId() : null;
        if (entity instanceof Group) {
            for (Entity member : ((Group)entity).getMembers()) {
                builder.members.add(member.getId());
            }
        }
        return builder.build();
    }

    @Deprecated
    public static LocationMemento newLocationMemento(Location location) {
        return MementosGenerators.newLocationMementoBuilder(location).build();
    }

    @Deprecated
    public static BasicLocationMemento.Builder newLocationMementoBuilder(Location location) {
        BasicLocationMemento.Builder builder = BasicLocationMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder((BrooklynObject)location, builder);
        Set nonPersistableFlagNames = MutableMap.builder().putAll(FlagUtils.getFieldsWithFlagsWithModifiers(location, 128)).putAll(FlagUtils.getFieldsWithFlagsWithModifiers(location, 8)).put((Object)"id", String.class).filterValues(Predicates.not((Predicate)Predicates.instanceOf(ConfigKey.class))).build().keySet();
        MutableMap persistableFlags = MutableMap.builder().putAll(FlagUtils.getFieldsWithFlagsExcludingModifiers(location, 136)).removeAll((Iterable)nonPersistableFlagNames).build();
        ConfigBag persistableConfig = new ConfigBag().copy(((LocationInternal)location).config().getLocalBag()).removeAll(nonPersistableFlagNames);
        builder.copyConfig(persistableConfig);
        builder.locationConfig.putAll((Map<String, Object>)persistableFlags);
        Location parentLocation = location.getParent();
        builder.parent = parentLocation != null ? parentLocation.getId() : null;
        for (Location child : location.getChildren()) {
            builder.children.add(child.getId());
        }
        return builder;
    }

    @Deprecated
    public static PolicyMemento newPolicyMemento(Policy policy) {
        BasicPolicyMemento.Builder builder = BasicPolicyMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder((BrooklynObject)policy, builder);
        Map config = ((AbstractPolicy)policy).config().getInternalConfigMap().getAllConfigLocalRaw();
        for (Map.Entry entry : config.entrySet()) {
            ConfigKey key = (ConfigKey)Preconditions.checkNotNull(entry.getKey(), (String)"config=%s", (Object[])new Object[]{config});
            Object value = MementosGenerators.configValueToPersistable(entry.getValue(), (BrooklynObject)policy, key.getName());
            builder.config.put(key.getName(), value);
        }
        builder.highlights(policy.getHighlights());
        MutableMap persistableFlags = MutableMap.builder().putAll(FlagUtils.getFieldsWithFlagsExcludingModifiers(policy, 136)).remove((Object)"id").remove((Object)"name").build();
        builder.config.putAll((Map<String, Object>)persistableFlags);
        return builder.build();
    }

    @Deprecated
    public static EnricherMemento newEnricherMemento(Enricher enricher) {
        BasicEnricherMemento.Builder builder = BasicEnricherMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder((BrooklynObject)enricher, builder);
        Map config = ((AbstractEnricher)enricher).config().getInternalConfigMap().getAllConfigLocalRaw();
        for (Map.Entry entry : config.entrySet()) {
            ConfigKey key = (ConfigKey)Preconditions.checkNotNull(entry.getKey(), (String)"config=%s", (Object[])new Object[]{config});
            Object value = MementosGenerators.configValueToPersistable(entry.getValue(), (BrooklynObject)enricher, key.getName());
            builder.config.put(key.getName(), value);
        }
        MutableMap persistableFlags = MutableMap.builder().putAll(FlagUtils.getFieldsWithFlagsExcludingModifiers(enricher, 136)).remove((Object)"id").remove((Object)"name").build();
        builder.config.putAll((Map<String, Object>)persistableFlags);
        return builder.build();
    }

    @Deprecated
    public static FeedMemento newFeedMemento(Feed feed) {
        BasicFeedMemento.Builder builder = BasicFeedMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder((BrooklynObject)feed, builder);
        Map config = ((AbstractFeed)feed).config().getInternalConfigMap().getAllConfigLocalRaw();
        for (Map.Entry entry : config.entrySet()) {
            ConfigKey key = (ConfigKey)Preconditions.checkNotNull(entry.getKey(), (String)"config=%s", (Object[])new Object[]{config});
            Object value = MementosGenerators.configValueToPersistable(entry.getValue(), (BrooklynObject)feed, key.getName());
            builder.config.put(key.getName(), value);
        }
        return builder.build();
    }

    private static CatalogItemMemento newCatalogItemMemento(CatalogItem<?, ?> catalogItem) {
        if (catalogItem instanceof CatalogItemDo) {
            catalogItem = ((CatalogItemDo)catalogItem).getDto();
        }
        BasicCatalogItemMemento.Builder builder = BasicCatalogItemMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder(catalogItem, builder);
        builder.catalogItemJavaType(catalogItem.getCatalogItemJavaType()).catalogItemType(catalogItem.getCatalogItemType()).containingBundle(catalogItem.getContainingBundle()).description(catalogItem.getDescription()).iconUrl(catalogItem.getIconUrl()).javaType(catalogItem.getJavaType()).libraries(catalogItem.getLibraries()).symbolicName(catalogItem.getSymbolicName()).specType(catalogItem.getSpecType()).version(catalogItem.getVersion()).planYaml(catalogItem.getPlanYaml()).deprecated(catalogItem.isDeprecated()).disabled(catalogItem.isDisabled());
        return builder.build();
    }

    private static ManagedBundleMemento newManagedBundleMemento(ManagedBundle bundle) {
        BasicManagedBundleMemento.Builder builder = BasicManagedBundleMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder((BrooklynObject)bundle, builder);
        builder.url(bundle.getUrl()).symbolicName(bundle.getSymbolicName()).version(bundle.getSuppliedVersionString());
        return builder.build();
    }

    private static void populateBrooklynObjectMementoBuilder(BrooklynObject instance, AbstractMemento.Builder<?> builder) {
        if (Proxy.isProxyClass(instance.getClass())) {
            throw new IllegalStateException("Attempt to create memento from proxy " + instance + " (would fail with wrong type)");
        }
        OsgiClassPrefixer prefixer = new OsgiClassPrefixer();
        Optional<String> typePrefix = prefixer.getPrefix(instance.getClass());
        builder.id = instance.getId();
        builder.displayName = instance.getDisplayName();
        builder.catalogItemId = instance.getCatalogItemId();
        builder.searchPath = instance.getCatalogItemIdSearchPath();
        builder.type = (typePrefix.isPresent() ? (String)typePrefix.get() : "") + instance.getClass().getName();
        builder.typeClass = instance.getClass();
        if (instance instanceof EntityAdjunct) {
            builder.uniqueTag = ((EntityAdjunct)instance).getUniqueTag();
        }
        for (Object tag : instance.tags().getTags()) {
            builder.tags.add(tag);
        }
        for (RelationshipType relationship : instance.relations().getRelationshipTypes()) {
            Set relations = instance.relations().getRelations(relationship);
            LinkedHashSet relationIds = Sets.newLinkedHashSet();
            for (Object r : relations) {
                relationIds.add(((BrooklynObject)r).getId());
            }
            builder.relations.put(relationship.getRelationshipTypeName(), relationIds);
        }
    }

    @Deprecated
    protected static Object configValueToPersistable(Object value) {
        return MementosGenerators.configValueToPersistable(value, null, null);
    }

    protected static Object configValueToPersistable(Object value, BrooklynObject obj, String keyName) {
        if (value instanceof Task) {
            Task task = (Task)value;
            String contextName = "";
            if (obj != null && Strings.isBlank((CharSequence)(contextName = obj.getCatalogItemId()))) {
                contextName = obj.getDisplayName();
            }
            if (keyName != null) {
                if (Strings.isNonBlank((CharSequence)contextName)) {
                    contextName = contextName + ":";
                }
                contextName = contextName + keyName;
            }
            String message = "Persisting " + contextName + " - encountered task " + value;
            Object result = null;
            if (task.isDone() && !task.isError()) {
                result = task.getUnchecked();
                message = message + "; persisting result " + result;
            } else {
                message = message + "; persisting as null";
                result = null;
            }
            if (WARNED_ON_PERSISTING_TASK_CONFIG.add(contextName)) {
                log.warn(message + " (subsequent values for this key will be at null)");
            } else {
                log.debug(message);
            }
            return result;
        }
        return value;
    }
}

