/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.util.guava.SerializablePredicate;

public class SensorEventPredicates {
    public static Predicate<SensorEvent<?>> sensorEqualTo(Sensor<?> val) {
        return SensorEventPredicates.sensorSatisfies(Predicates.equalTo(val));
    }

    public static Predicate<SensorEvent<?>> sensorSatisfies(Predicate<? super Sensor<?>> condition) {
        return new SensorSatisfies(condition);
    }

    public static <T> Predicate<SensorEvent<T>> valueEqualTo(T val) {
        return SensorEventPredicates.valueSatisfies(Predicates.equalTo(val));
    }

    public static <T> Predicate<SensorEvent<T>> valueSatisfies(Predicate<? super T> condition) {
        return new ValueSatisfies<T>(condition);
    }

    protected static class ValueSatisfies<T>
    implements SerializablePredicate<SensorEvent<T>> {
        private static final long serialVersionUID = 2805443606039228221L;
        protected final Predicate<? super T> condition;

        protected ValueSatisfies(Predicate<? super T> condition) {
            this.condition = condition;
        }

        public boolean apply(@Nullable SensorEvent<T> input) {
            return input != null && this.condition.apply(input.getValue());
        }

        public String toString() {
            return "valueSatisfies(" + this.condition + ")";
        }
    }

    protected static class SensorSatisfies
    implements SerializablePredicate<SensorEvent<?>> {
        private static final long serialVersionUID = -3585200249520308941L;
        protected final Predicate<? super Sensor<?>> condition;

        protected SensorSatisfies(Predicate<? super Sensor<?>> condition) {
            this.condition = condition;
        }

        public boolean apply(@Nullable SensorEvent<?> input) {
            return input != null && this.condition.apply((Object)input.getSensor());
        }

        public String toString() {
            return "sensorSatisfies(" + this.condition + ")";
        }
    }
}

