/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.entity.group.DynamicFabricImpl;
import org.apache.brooklyn.entity.group.DynamicRegionsFabric;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRegionsFabricImpl
extends DynamicFabricImpl
implements DynamicRegionsFabric {
    private static final Logger log = LoggerFactory.getLogger(DynamicRegionsFabricImpl.class);

    @Override
    public String addRegion(String location) {
        Preconditions.checkNotNull((Object)location, (Object)"location");
        Location l = this.getManagementContext().getLocationRegistry().getLocationManaged(location);
        this.addLocations(Arrays.asList(l));
        Entity e = this.addCluster(l);
        ((EntityInternal)e).addLocations(Arrays.asList(l));
        if (e instanceof Startable) {
            Task task = e.invoke(Startable.START, (Map)ImmutableMap.of((Object)"locations", (Object)ImmutableList.of((Object)l)));
            task.getUnchecked();
        }
        return e.getId();
    }

    @Override
    public void removeRegion(String id) {
        Entity entity = this.getManagementContext().getEntityManager().getEntity(id);
        Preconditions.checkNotNull((Object)entity, (String)"No entity found for %s", (Object[])new Object[]{id});
        Preconditions.checkArgument((boolean)this.equals(entity.getParent()), (String)"Wrong parent (%s) for %s", (Object[])new Object[]{entity.getParent(), entity});
        Collection childLocations = entity.getLocations();
        if (entity instanceof Startable) {
            try {
                Entities.invokeEffector((Entity)this, entity, Startable.STOP).get();
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Error stopping " + entity + " (" + e + "); proceeding to remove it anyway");
                log.debug("Error stopping " + entity + " (" + e + "); proceeding to remove it anyway", (Throwable)e);
            }
        }
        this.removeChild(entity);
        this.removeLocations(childLocations);
    }
}

