/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import com.thoughtworks.xstream.mapper.DefaultMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.xstream.ClassRenamingMapper;
import org.apache.brooklyn.util.core.xstream.CompilerIndependentOuterClassFieldMapper;
import org.apache.brooklyn.util.core.xstream.EnumCaseForgivingConverter;
import org.apache.brooklyn.util.core.xstream.ImmutableListConverter;
import org.apache.brooklyn.util.core.xstream.ImmutableMapConverter;
import org.apache.brooklyn.util.core.xstream.ImmutableSetConverter;
import org.apache.brooklyn.util.core.xstream.Inet4AddressConverter;
import org.apache.brooklyn.util.core.xstream.MutableSetConverter;
import org.apache.brooklyn.util.core.xstream.OsgiClassnameMapper;
import org.apache.brooklyn.util.core.xstream.StringKeyMapConverter;

public class XmlSerializer<T> {
    private final Map<String, String> deserializingClassRenames;
    protected final XStream xstream;

    public XmlSerializer() {
        this((Map<String, String>)ImmutableMap.of());
    }

    public XmlSerializer(Map<String, String> deserializingClassRenames) {
        this(null, deserializingClassRenames);
    }

    public XmlSerializer(ClassLoader loader, Map<String, String> deserializingClassRenames) {
        this.deserializingClassRenames = deserializingClassRenames;
        this.xstream = new XStream(){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return XmlSerializer.this.wrapMapperForNormalUsage((Mapper)super.wrapMapper(next));
            }
        };
        XStream.setupDefaultSecurity((XStream)this.xstream);
        this.xstream.allowTypesByWildcard(new String[]{"**"});
        if (loader != null) {
            this.xstream.setClassLoader(loader);
        }
        this.xstream.registerConverter((SingleValueConverter)this.newCustomJavaClassConverter(), 0);
        this.xstream.alias("map", Map.class, LinkedHashMap.class);
        this.xstream.alias("set", Set.class, LinkedHashSet.class);
        this.xstream.registerConverter((Converter)new StringKeyMapConverter(this.xstream.getMapper()), 10);
        this.xstream.alias("MutableMap", MutableMap.class);
        this.xstream.alias("MutableSet", MutableSet.class);
        this.xstream.alias("MutableList", MutableList.class);
        this.xstream.registerConverter((Converter)new MutableSetConverter(this.xstream.getMapper()));
        this.xstream.aliasType("ImmutableList", ImmutableList.class);
        this.xstream.registerConverter((Converter)new ImmutableListConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((Converter)new ImmutableSetConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((Converter)new ImmutableMapConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((Converter)new EnumCaseForgivingConverter());
        this.xstream.registerConverter((Converter)new Inet4AddressConverter());
        this.xstream.autodetectAnnotations(true);
    }

    private JavaClassConverter newCustomJavaClassConverter() {
        return new JavaClassConverter((Mapper)this.wrapMapperForHandlingClasses((Mapper)new DefaultMapper(this.xstream.getClassLoaderReference()))){};
    }

    protected MapperWrapper wrapMapperForHandlingClasses(Mapper next) {
        MapperWrapper result = new CompilerIndependentOuterClassFieldMapper(next);
        Supplier<ClassLoader> classLoaderSupplier = new Supplier<ClassLoader>(){

            public ClassLoader get() {
                return XmlSerializer.this.xstream.getClassLoaderReference().getReference();
            }
        };
        result = new ClassRenamingMapper((Mapper)result, this.deserializingClassRenames, (Supplier<? extends ClassLoader>)classLoaderSupplier);
        result = new OsgiClassnameMapper(new Supplier<XStream>(){

            public XStream get() {
                return XmlSerializer.this.xstream;
            }
        }, result);
        return result;
    }

    protected MapperWrapper wrapMapperForNormalUsage(Mapper next) {
        return this.wrapMapperForHandlingClasses(next);
    }

    public void serialize(Object object, Writer writer) {
        this.xstream.toXML(object, writer);
    }

    public T deserialize(Reader xml) {
        return (T)this.xstream.fromXML(xml);
    }

    public String toString(T memento) {
        StringWriter writer = new StringWriter();
        this.serialize(memento, writer);
        return ((Object)writer).toString();
    }

    public T fromString(String xml) {
        return this.deserialize(new StringReader(xml));
    }
}

