/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.spi.pdp;

import java.util.Map;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.spi.AbstractResource;
import org.apache.brooklyn.camp.spi.ApplicationComponentTemplate;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.PlatformComponentTemplate;
import org.apache.brooklyn.camp.spi.PlatformTransaction;
import org.apache.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;

public class AssemblyTemplateConstructor {
    private final AssemblyTemplate.Builder<? extends AssemblyTemplate> builder;
    private final CampPlatform campPlatform;
    protected PlatformTransaction transaction;

    public AssemblyTemplateConstructor(CampPlatform campPlatform) {
        this.campPlatform = campPlatform;
        this.builder = AssemblyTemplate.builder();
        this.transaction = this.campPlatform.transaction();
    }

    @Deprecated
    public AssemblyTemplate commit() {
        return this.construct(true);
    }

    public AssemblyTemplate construct(boolean save) {
        this.checkState();
        AbstractResource at = this.builder.build();
        if (!save) {
            this.transaction.clear();
        }
        this.transaction.commit();
        this.transaction = null;
        return at;
    }

    public void name(String name) {
        this.checkState();
        this.builder.name(name);
    }

    public void description(String description) {
        this.checkState();
        this.builder.description(description);
    }

    public void sourceCode(String sourceCode) {
        this.checkState();
        this.builder.sourceCode(sourceCode);
    }

    public void addCustomAttributes(Map<String, Object> attrs) {
        for (Map.Entry<String, Object> attr : attrs.entrySet()) {
            this.builder.customAttribute(attr.getKey(), attr.getValue());
        }
    }

    public void instantiator(Class<? extends AssemblyTemplateInstantiator> instantiator) {
        this.checkState();
        this.builder.instantiator(instantiator);
    }

    public Class<? extends AssemblyTemplateInstantiator> getInstantiator() {
        this.checkState();
        return this.builder.peek().getInstantiator();
    }

    public void add(ApplicationComponentTemplate act) {
        this.checkState();
        this.builder.add(act);
        this.transaction.add(act);
    }

    public void add(PlatformComponentTemplate pct) {
        this.checkState();
        this.builder.add(pct);
        this.transaction.add(pct);
    }

    protected void checkState() {
        if (this.transaction == null) {
            throw new IllegalStateException("transaction already committed");
        }
    }
}

