/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Set;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.net.Networking;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsWinRmMachineLocation
extends WinRmMachineLocation
implements JcloudsMachineLocation {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsWinRmMachineLocation.class);
    @SetFromFlag
    JcloudsLocation jcloudsParent;
    @SetFromFlag
    @Deprecated
    NodeMetadata node;
    @SetFromFlag
    @Deprecated
    Template template;
    @SetFromFlag
    String nodeId;
    @SetFromFlag
    String imageId;
    @SetFromFlag
    Set<String> privateAddresses;
    @SetFromFlag
    Set<String> publicAddresses;
    @SetFromFlag
    String hostname;
    private transient Optional<NodeMetadata> _node;
    private transient Optional<Template> _template;
    private transient Optional<Image> _image;
    private transient String _privateHostname;

    public void init() {
        if (this.jcloudsParent != null) {
            super.init();
            if (this.node != null) {
                this.setNode(this.node);
            }
            if (this.template != null) {
                this.setTemplate(this.template);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Not doing init() of {} because parent not set; presuming rebinding", (Object)this);
        }
    }

    public void rebind() {
        super.rebind();
        if (this.node != null) {
            this.setNode(this.node);
            this.node = null;
        }
        if (this.template != null) {
            this.setTemplate(this.template);
            this.template = null;
        }
    }

    public String toVerboseString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.getId()).add("name", (Object)this.getDisplayName()).add("user", (Object)this.getUser()).add("address", (Object)this.getAddress()).add("port", this.getPort()).add("node", this._node).add("nodeId", (Object)this.getJcloudsId()).add("imageId", (Object)this.getImageId()).add("privateAddresses", this.getPrivateAddresses()).add("publicAddresses", this.getPublicAddresses()).add("parentLocation", (Object)this.getParent()).add("osDetails", (Object)this.getOsDetails()).toString();
    }

    protected void setNode(NodeMetadata node) {
        this.node = null;
        this.nodeId = node.getId();
        this.imageId = node.getImageId();
        this.privateAddresses = node.getPrivateAddresses();
        this.publicAddresses = node.getPublicAddresses();
        this.hostname = node.getHostname();
        this._node = Optional.of((Object)node);
    }

    protected void setTemplate(Template template) {
        this.template = null;
        this._template = Optional.of((Object)template);
        this._image = Optional.fromNullable((Object)template.getImage());
    }

    @Override
    public JcloudsLocation getParent() {
        return this.jcloudsParent;
    }

    @Override
    public Optional<NodeMetadata> getOptionalNode() {
        if (this._node == null) {
            this._node = Optional.fromNullable((Object)this.getParent().getComputeService().getNodeMetadata(this.nodeId));
        }
        return this._node;
    }

    @VisibleForTesting
    Optional<NodeMetadata> peekNode() {
        return this._node;
    }

    protected Optional<Image> getOptionalImage() {
        if (this._image == null) {
            this._image = Optional.fromNullable((Object)this.getParent().getComputeService().getImage(this.imageId));
        }
        return this._image;
    }

    @Deprecated
    protected Optional<Template> getOptionalTemplate() {
        if (this._template == null) {
            this._template = Optional.absent();
        }
        return this._template;
    }

    @Override
    @Deprecated
    public NodeMetadata getNode() {
        Optional<NodeMetadata> result = this.getOptionalNode();
        if (result.isPresent()) {
            return (NodeMetadata)result.get();
        }
        throw new IllegalStateException("Node " + this.nodeId + " not present in " + this.getParent());
    }

    public String getHostname() {
        if (this.hostname != null) {
            return this.hostname;
        }
        InetAddress address = this.getAddress();
        return address != null ? address.getHostAddress() : null;
    }

    public Set<String> getPublicAddresses() {
        return this.publicAddresses == null ? ImmutableSet.of() : this.publicAddresses;
    }

    public Set<String> getPrivateAddresses() {
        return this.privateAddresses == null ? ImmutableSet.of() : this.privateAddresses;
    }

    @Override
    public String getSubnetHostname() {
        if (this._privateHostname == null) {
            for (String p : this.getPrivateAddresses()) {
                if (Networking.isLocalOnly((String)p)) continue;
                this._privateHostname = p;
            }
            if (JavaGroovyEquivalents.groovyTruth(this.getPublicAddresses())) {
                this._privateHostname = this.getPublicAddresses().iterator().next();
            } else if (JavaGroovyEquivalents.groovyTruth((String)this.getHostname())) {
                this._privateHostname = this.getHostname();
            } else {
                return null;
            }
        }
        return this._privateHostname;
    }

    public String getSubnetIp() {
        Optional<String> privateAddress = this.getPrivateAddress();
        if (privateAddress.isPresent()) {
            return (String)privateAddress.get();
        }
        if (JavaGroovyEquivalents.groovyTruth(this.publicAddresses)) {
            return this.publicAddresses.iterator().next();
        }
        if (this.node != null && JavaGroovyEquivalents.groovyTruth((Collection)this.node.getPublicAddresses())) {
            return (String)this.node.getPublicAddresses().iterator().next();
        }
        return null;
    }

    protected Optional<String> getPrivateAddress() {
        for (String p : this.getPrivateAddresses()) {
            if (Networking.isLocalOnly((String)p)) continue;
            return Optional.of((Object)p);
        }
        return Optional.absent();
    }

    @Override
    public String getJcloudsId() {
        return this.nodeId;
    }

    protected String getImageId() {
        return this.imageId;
    }
}

