/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.system_service;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.entity.system_service.SystemServiceEnricher;
import org.apache.brooklyn.util.core.task.Tasks;

public class EntityLaunchListener
implements Runnable,
SensorEventListener<Lifecycle> {
    private static final String SSH_LAUNCH_TASK_PREFIX = "ssh: launching";
    private static final String LAUNCH_CHECK_SKIP_TAG = "system-service-update";
    private final AtomicReference<Task<?>> launchTaskRef = new AtomicReference();
    private final SystemServiceEnricher enricher;

    public EntityLaunchListener(SystemServiceEnricher enricher) {
        this.enricher = (SystemServiceEnricher)((Object)Preconditions.checkNotNull((Object)((Object)enricher), (Object)"enricher"));
    }

    public void onEvent(SensorEvent<Lifecycle> event) {
        Task<?> launchTask;
        if (event.getValue() == Lifecycle.RUNNING && (launchTask = this.getLatestLaunchTask(this.enricher.getEntity())) != null) {
            this.launchTaskRef.set(launchTask);
            if (!launchTask.isDone()) {
                launchTask.addListener((Runnable)this, (Executor)this.enricher.getEntityExecutionContext());
            }
            if (launchTask.isDone()) {
                this.run();
            }
        }
    }

    @Override
    public void run() {
        Task launchTask = this.launchTaskRef.getAndSet(null);
        if (launchTask == null) {
            return;
        }
        if (launchTask.isError()) {
            return;
        }
        this.enricher.onLaunched(launchTask);
    }

    private Task<?> getLatestLaunchTask(Entity entity) {
        Task<?> launchTask;
        Task startEffector = null;
        ExecutionManager executionmgr = this.enricher.getManagementContext().getExecutionManager();
        Set entityTasks = BrooklynTaskTags.getTasksInEntityContext((ExecutionManager)executionmgr, (Entity)entity);
        for (Task t : entityTasks) {
            BrooklynTaskTags.EffectorCallTag effectorTag;
            if (!BrooklynTaskTags.isEffectorTask((Task)t) || !SystemServiceEnricher.LAUNCH_EFFECTOR_NAMES.contains((effectorTag = BrooklynTaskTags.getEffectorCallTag((Task)t, (boolean)false)).getEffectorName()) || BrooklynTaskTags.hasTag((Task)t, (Object)LAUNCH_CHECK_SKIP_TAG)) continue;
            if (startEffector == null || startEffector.getStartTimeUtc() < t.getStartTimeUtc()) {
                startEffector = t;
            }
            BrooklynTaskTags.addTagDynamically((TaskAdaptable)t, (Object)LAUNCH_CHECK_SKIP_TAG);
        }
        if (startEffector != null && (launchTask = this.findSshLaunchChild(startEffector)) != null) {
            return launchTask;
        }
        return null;
    }

    private Task<?> findSshLaunchChild(Task<?> t) {
        Iterable children = Tasks.children(t);
        for (Task c : children) {
            if (!c.getDisplayName().startsWith(SSH_LAUNCH_TASK_PREFIX)) continue;
            return c;
        }
        for (Task c : children) {
            Task<?> launchTask = this.findSshLaunchChild(c);
            if (launchTask == null) continue;
            return launchTask;
        }
        return null;
    }
}

