/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.cache;

import java.util.Hashtable;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.compute.ComputeService;
import org.jclouds.karaf.cache.BasicCacheProvider;
import org.jclouds.karaf.cache.CacheManager;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.karaf.cache.utils.CacheUtils;
import org.jclouds.karaf.recipe.RecipeProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker computeServiceTracker;
    private ServiceTracker computeCacheableTracker;
    private ServiceTracker blobStoreTracker;
    private ServiceTracker blobStoreCacheableTracker;
    private ServiceTracker recipeProviderTracker;
    private ServiceTracker recipeCacheableTracker;
    private ServiceRegistration cacheProviderRegistration;
    private final CacheManager<ComputeService> computeCacheManager = new CacheManager();
    private final CacheManager<BlobStore> blobCacheManager = new CacheManager();
    private final CacheManager<RecipeProvider> recipeCacheManager = new CacheManager();

    public void start(BundleContext context) throws Exception {
        BasicCacheProvider cacheProvider = new BasicCacheProvider();
        this.cacheProviderRegistration = context.registerService(CacheProvider.class.getName(), (Object)cacheProvider, new Hashtable());
        this.computeServiceTracker = CacheUtils.createServiceCacheTracker(context, ComputeService.class, this.computeCacheManager);
        this.computeCacheableTracker = CacheUtils.createCacheableTracker(context, "jclouds.computeservice", this.computeCacheManager);
        this.blobStoreTracker = CacheUtils.createServiceCacheTracker(context, BlobStore.class, this.blobCacheManager);
        this.blobStoreCacheableTracker = CacheUtils.createCacheableTracker(context, "jclouds.blobstore", this.blobCacheManager);
        this.recipeProviderTracker = CacheUtils.createServiceCacheTracker(context, RecipeProvider.class, this.recipeCacheManager);
        this.recipeCacheableTracker = CacheUtils.createCacheableTracker(context, "jclouds.recipeprovider", this.recipeCacheManager);
        this.computeServiceTracker.open();
        this.computeCacheableTracker.open();
        this.blobStoreTracker.open();
        this.blobStoreCacheableTracker.open();
        this.recipeProviderTracker.open();
        this.recipeCacheableTracker.open();
        this.computeCacheManager.init();
        this.blobCacheManager.init();
        this.recipeCacheManager.init();
    }

    public void stop(BundleContext context) throws Exception {
        this.computeCacheManager.destroy();
        this.blobCacheManager.destroy();
        this.recipeCacheManager.destroy();
        if (this.cacheProviderRegistration != null) {
            this.cacheProviderRegistration.unregister();
        }
        if (this.computeServiceTracker != null) {
            this.computeServiceTracker.close();
        }
        if (this.computeCacheableTracker != null) {
            this.computeCacheableTracker.close();
        }
        if (this.blobStoreTracker != null) {
            this.blobStoreTracker.close();
        }
        if (this.blobStoreCacheableTracker != null) {
            this.blobStoreCacheableTracker.close();
        }
        if (this.recipeProviderTracker != null) {
            this.recipeProviderTracker.close();
        }
        if (this.recipeCacheableTracker != null) {
            this.recipeCacheableTracker.close();
        }
    }
}

