/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.osgi.karaf;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.osgi.karaf.KarafContainer;
import org.apache.brooklyn.entity.osgi.karaf.KarafContainerImpl;
import org.apache.brooklyn.entity.osgi.karaf.KarafDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;

public class KarafSshDriver
extends JavaSoftwareProcessSshDriver
implements KarafDriver {
    public KarafSshDriver(KarafContainerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public KarafContainerImpl getEntity() {
        return (KarafContainerImpl)super.getEntity();
    }

    protected String getLogFileLocation() {
        return Os.mergePaths((String[])new String[]{this.getRunDir(), "data", "karaf.out"});
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList commands = ImmutableList.builder().addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)BashCommands.INSTALL_TAR).add((Object)("tar xzfv " + saveAs)).build();
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        ports.put("jmxPort", this.getJmxPort());
        ports.put("rmiRegistryPort", this.getRmiRegistryPort());
        Networking.checkPortsValid(ports);
        this.newScript((String)"customizing").body.append(new CharSequence[]{String.format("cd %s", this.getRunDir()), String.format("cp -R %s/{bin,etc,lib,system,deploy} . || exit $!", this.getExpandedInstallDir()), String.format("sed -i.bk 's/rmiRegistryPort = 1099/rmiRegistryPort = %s/g' etc/org.apache.karaf.management.cfg", this.getRmiRegistryPort()), String.format("sed -i.bk 's/rmiServerPort = 44444/rmiServerPort = %s/g' etc/org.apache.karaf.management.cfg", this.getJmxPort())}).execute();
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").body.append((CharSequence)"nohup ./bin/start").execute();
    }

    public boolean isRunning() {
        Integer pid = (Integer)this.entity.getAttribute(KarafContainer.KARAF_PID);
        if (pid != null) {
            return this.newScript((String)"check-running").body.append((CharSequence)String.format("ps aux | grep 'karaf' | grep %s > /dev/null", pid)).execute() == 0;
        }
        return this.newScript((String)"check-running").body.append(new CharSequence[]{String.format("cd %s/instances/", this.getRunDir()), "[ $(uname) = \"Darwin\" ] && pid=$(sed -n -e 's/.*pid=\\([0-9]*\\)$/\\1/p' instance.properties) || pid=$(sed -r -n -e 's/.*pid=([0-9]*)$/\\1/p' instance.properties)", "ps aux | grep 'karaf' | grep $(echo ${pid:-X}) > /dev/null"}).execute() == 0;
    }

    public void stop() {
        this.newScript((String)"stopping").environmentVariablesReset().body.append((CharSequence)String.format("%s/bin/stop", this.getRunDir())).execute();
    }

    public void kill() {
        this.stop();
    }

    protected List<String> getCustomJavaConfigOptions() {
        return MutableList.builder().addAll((Iterable)super.getCustomJavaConfigOptions()).add((Object)"-Xms200m").add((Object)"-Xmx800m").add((Object)"-XX:MaxPermSize=400m").build();
    }
}

