/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

public class RunScriptOptions {
    public static final RunScriptOptions NONE = new ImmutableRunScriptOptions(new RunScriptOptions());
    protected int port = -1;
    protected int seconds = -1;
    protected String taskName;
    protected boolean runAsRoot = true;
    protected boolean blockOnComplete = true;
    protected boolean wrapInInitScript = true;
    protected String loginUser;
    protected Boolean authenticateSudo;
    protected Optional<String> loginPassword;
    protected Optional<String> loginPrivateKey;

    public void copyTo(RunScriptOptions to) {
        if (this.getPort() != -1) {
            to.blockOnPort(this.getPort(), this.getSeconds());
        }
        if (this.getTaskName() != null) {
            to.nameTask(this.getTaskName());
        }
        to.runAsRoot(this.shouldRunAsRoot());
        to.blockOnComplete(this.shouldBlockOnComplete());
        to.wrapInInitScript(this.shouldWrapInInitScript());
        if (this.hasLoginPasswordOption()) {
            to.overrideLoginPassword(this.loginPassword);
        }
        if (this.hasLoginPrivateKeyOption()) {
            to.overrideLoginPrivateKey(this.loginPrivateKey);
        }
        if (this.getLoginUser() != null) {
            to.overrideLoginUser(this.getLoginUser());
        }
        if (this.shouldAuthenticateSudo() != null) {
            to.overrideAuthenticateSudo(this.shouldAuthenticateSudo());
        }
    }

    public RunScriptOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        Preconditions.checkNotNull((Object)overridingCredentials, (Object)"overridingCredentials");
        this.loginUser = overridingCredentials.getUser();
        this.loginPassword = overridingCredentials.getOptionalPassword();
        this.loginPrivateKey = overridingCredentials.getOptionalPrivateKey();
        this.authenticateSudo = overridingCredentials.shouldAuthenticateSudo() ? Boolean.valueOf(true) : null;
        return this;
    }

    public RunScriptOptions overrideLoginUser(String loginUser) {
        Preconditions.checkNotNull((Object)loginUser, (Object)"loginUser");
        this.loginUser = loginUser;
        return this;
    }

    public RunScriptOptions overrideLoginPassword(String password) {
        Preconditions.checkNotNull((Object)password, (Object)"password");
        this.loginPassword = Optional.of((Object)password);
        return this;
    }

    public RunScriptOptions overrideLoginPrivateKey(String privateKey) {
        Preconditions.checkNotNull((Object)privateKey, (Object)"privateKey");
        this.loginPrivateKey = Optional.of((Object)privateKey);
        return this;
    }

    public RunScriptOptions overrideLoginPassword(Optional<String> password) {
        Preconditions.checkNotNull(password, (Object)"password");
        this.loginPassword = password;
        return this;
    }

    public RunScriptOptions overrideLoginPrivateKey(Optional<String> privateKey) {
        Preconditions.checkNotNull(privateKey, (Object)"privateKey");
        this.loginPrivateKey = privateKey;
        return this;
    }

    public RunScriptOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        this.authenticateSudo = authenticateSudo;
        return this;
    }

    public RunScriptOptions nameTask(String name) {
        this.taskName = name;
        return this;
    }

    public RunScriptOptions runAsRoot(boolean runAsRoot) {
        this.runAsRoot = runAsRoot;
        return this;
    }

    public RunScriptOptions wrapInInitScript(boolean wrapInInitScript) {
        this.wrapInInitScript = wrapInInitScript;
        return this;
    }

    public RunScriptOptions blockOnComplete(boolean blockOnComplete) {
        this.blockOnComplete = blockOnComplete;
        return this;
    }

    public RunScriptOptions blockOnPort(int port, int seconds) {
        Preconditions.checkArgument((port > 0 && port < 65536 ? 1 : 0) != 0, (Object)"port must be a positive integer < 65535");
        Preconditions.checkArgument((seconds > 0 ? 1 : 0) != 0, (Object)"seconds must be a positive integer");
        this.port = port;
        this.seconds = seconds;
        return this;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getPort() {
        return this.port;
    }

    public int getSeconds() {
        return this.seconds;
    }

    @Nullable
    public String getLoginUser() {
        return this.loginUser;
    }

    @Nullable
    public Boolean shouldAuthenticateSudo() {
        return this.authenticateSudo;
    }

    public boolean hasLoginPasswordOption() {
        return this.loginPassword != null;
    }

    public boolean hasLoginPassword() {
        return this.hasLoginPasswordOption() && this.loginPassword.isPresent();
    }

    @Nullable
    public String getLoginPassword() {
        return this.hasLoginPassword() ? (String)this.loginPassword.get() : null;
    }

    public boolean hasLoginPrivateKeyOption() {
        return this.loginPrivateKey != null;
    }

    public boolean hasLoginPrivateKey() {
        return this.hasLoginPrivateKeyOption() && this.loginPrivateKey.isPresent();
    }

    @Nullable
    public String getLoginPrivateKey() {
        return this.hasLoginPrivateKey() ? (String)this.loginPrivateKey.get() : null;
    }

    public boolean shouldRunAsRoot() {
        return this.runAsRoot;
    }

    public boolean shouldBlockOnComplete() {
        return this.blockOnComplete;
    }

    public boolean shouldWrapInInitScript() {
        return this.wrapInInitScript;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunScriptOptions that = (RunScriptOptions)RunScriptOptions.class.cast(o);
        return Objects.equal((Object)this.loginUser, (Object)that.loginUser) && Objects.equal(this.loginPassword, that.loginPassword) && Objects.equal(this.loginPrivateKey, that.loginPrivateKey) && Objects.equal((Object)this.authenticateSudo, (Object)that.authenticateSudo) && Objects.equal((Object)this.port, (Object)that.port) && Objects.equal((Object)this.seconds, (Object)that.seconds) && Objects.equal((Object)this.taskName, (Object)that.taskName) && Objects.equal((Object)this.runAsRoot, (Object)that.runAsRoot) && Objects.equal((Object)this.blockOnComplete, (Object)that.blockOnComplete) && Objects.equal((Object)this.wrapInInitScript, (Object)that.wrapInInitScript);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.loginUser, this.loginPassword, this.loginPrivateKey, this.authenticateSudo, this.port, this.seconds, this.taskName, this.taskName, this.blockOnComplete, this.wrapInInitScript});
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = MoreObjects.toStringHelper((String)"").omitNullValues();
        toString.add("loginUser", (Object)this.loginUser);
        if (this.loginPassword != null && this.loginPassword.isPresent()) {
            toString.add("loginPasswordPresent", true);
        }
        if (this.loginPrivateKey != null && this.loginPrivateKey.isPresent()) {
            toString.add("loginPrivateKeyPresent", true);
        }
        toString.add("authenticateSudo", (Object)this.authenticateSudo);
        if (this.port != -1 && this.seconds != -1) {
            toString.add("blockOnPort:seconds", (Object)(this.port + ":" + this.seconds));
        }
        toString.add("taskName", (Object)this.taskName);
        if (!this.runAsRoot) {
            toString.add("runAsRoot", this.runAsRoot);
        }
        if (!this.blockOnComplete) {
            toString.add("blockOnComplete", this.blockOnComplete);
        }
        if (!this.wrapInInitScript) {
            toString.add("wrapInInitScript", this.wrapInInitScript);
        }
        return toString;
    }

    public static class Builder {
        public static RunScriptOptions nameTask(String name) {
            RunScriptOptions options = new RunScriptOptions();
            return options.nameTask(name);
        }

        public static RunScriptOptions overrideLoginUser(String user) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginUser(user);
        }

        public static RunScriptOptions overrideLoginPassword(String password) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginPassword(password);
        }

        public static RunScriptOptions overrideLoginPrivateKey(String privateKey) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static RunScriptOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static RunScriptOptions overrideLoginCredentials(LoginCredentials credentials) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static RunScriptOptions runAsRoot(boolean value) {
            RunScriptOptions options = new RunScriptOptions();
            return options.runAsRoot(value);
        }

        public static RunScriptOptions blockOnComplete(boolean value) {
            RunScriptOptions options = new RunScriptOptions();
            return options.blockOnComplete(value);
        }

        public static RunScriptOptions wrapInInitScript(boolean value) {
            RunScriptOptions options = new RunScriptOptions();
            return options.wrapInInitScript(value);
        }

        public static RunScriptOptions blockOnPort(int port, int seconds) {
            RunScriptOptions options = new RunScriptOptions();
            return options.blockOnPort(port, seconds);
        }
    }

    public static class ImmutableRunScriptOptions
    extends RunScriptOptions {
        private final RunScriptOptions delegate;

        public ImmutableRunScriptOptions(RunScriptOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean shouldRunAsRoot() {
            return this.delegate.shouldRunAsRoot();
        }

        @Override
        public RunScriptOptions runAsRoot(boolean runAsRoot) {
            throw new IllegalArgumentException("runAsRoot is immutable");
        }

        @Override
        public boolean shouldBlockOnComplete() {
            return this.delegate.shouldBlockOnComplete();
        }

        @Override
        public RunScriptOptions blockOnComplete(boolean blockOnComplete) {
            throw new IllegalArgumentException("blockOnComplete is immutable");
        }

        @Override
        public RunScriptOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
            throw new IllegalArgumentException("overridingCredentials is immutable");
        }

        @Override
        public RunScriptOptions overrideLoginPassword(String password) {
            throw new IllegalArgumentException("password is immutable");
        }

        @Override
        public RunScriptOptions overrideLoginPrivateKey(String privateKey) {
            throw new IllegalArgumentException("privateKey is immutable");
        }

        @Override
        public RunScriptOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            throw new IllegalArgumentException("authenticateSudo is immutable");
        }

        @Override
        public String getLoginUser() {
            return this.delegate.getLoginUser();
        }

        @Override
        public Boolean shouldAuthenticateSudo() {
            return this.delegate.shouldAuthenticateSudo();
        }

        @Override
        public String getLoginPassword() {
            return this.delegate.getLoginPassword();
        }

        @Override
        public String getLoginPrivateKey() {
            return this.delegate.getLoginPrivateKey();
        }

        @Override
        public boolean shouldWrapInInitScript() {
            return this.delegate.shouldWrapInInitScript();
        }

        @Override
        public RunScriptOptions overrideLoginUser(String loginUser) {
            throw new IllegalArgumentException("loginUser is immutable");
        }

        @Override
        public RunScriptOptions wrapInInitScript(boolean wrapInInitScript) {
            throw new IllegalArgumentException("wrapInInitScript is immutable");
        }

        @Override
        public String getTaskName() {
            return this.delegate.getTaskName();
        }

        @Override
        public RunScriptOptions nameTask(String name) {
            throw new IllegalArgumentException("taskName is immutable");
        }

        @Override
        public RunScriptOptions blockOnPort(int port, int seconds) {
            throw new IllegalArgumentException("port, seconds are immutable");
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public int getSeconds() {
            return this.delegate.getSeconds();
        }
    }
}

