/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Manage and invoke AWS Rekognition.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Rekognition2EndpointBuilderFactory {

    /**
     * Builder for endpoint for the AWS Rekognition component.
     */
    public interface Rekognition2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedRekognition2EndpointBuilder advanced() {
            return (AdvancedRekognition2EndpointBuilder) this;
        }

        /**
         * The operation to perform. It can be listFunctions, getFunction,
         * createFunction, deleteFunction or invokeFunction.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.rekognition.Rekognition2Operations</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder operation(org.apache.camel.component.aws2.rekognition.Rekognition2Operations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform. It can be listFunctions, getFunction,
         * createFunction, deleteFunction or invokeFunction.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.rekognition.Rekognition2Operations</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder pojoRequest(String pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * The region in which Rekognition client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example, ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * Set whether the Rekognition client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Rekognition client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Rekognition client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Rekognition client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * To define a proxy host when instantiating the Rekognition client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Rekognition client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Rekognition client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Rekognition client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Rekognition client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * Set whether the Rekognition client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Rekognition.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the Rekognition client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Rekognition.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Rekognition component.
     */
    public interface AdvancedRekognition2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default Rekognition2EndpointBuilder basic() {
            return (Rekognition2EndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedRekognition2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedRekognition2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To use an existing configured AwsRekognitionClient client.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.rekognition.RekognitionClient</code> type.
         * 
         * Group: advanced
         * 
         * @param awsRekognitionClient the value to set
         * @return the dsl builder
         */
        default AdvancedRekognition2EndpointBuilder awsRekognitionClient(software.amazon.awssdk.services.rekognition.RekognitionClient awsRekognitionClient) {
            doSetProperty("awsRekognitionClient", awsRekognitionClient);
            return this;
        }
        /**
         * To use an existing configured AwsRekognitionClient client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.rekognition.RekognitionClient</code> type.
         * 
         * Group: advanced
         * 
         * @param awsRekognitionClient the value to set
         * @return the dsl builder
         */
        default AdvancedRekognition2EndpointBuilder awsRekognitionClient(String awsRekognitionClient) {
            doSetProperty("awsRekognitionClient", awsRekognitionClient);
            return this;
        }
    }

    public interface Rekognition2Builders {
        /**
         * AWS Rekognition (camel-aws2-rekognition)
         * Manage and invoke AWS Rekognition.
         * 
         * Category: cloud,ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-aws2-rekognition
         * 
         * @return the dsl builder for the headers' name.
         */
        default Rekognition2HeaderNameBuilder aws2Rekognition() {
            return Rekognition2HeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS Rekognition (camel-aws2-rekognition)
         * Manage and invoke AWS Rekognition.
         * 
         * Category: cloud,ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-aws2-rekognition
         * 
         * Syntax: <code>aws2-rekognition:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder aws2Rekognition(String path) {
            return Rekognition2EndpointBuilderFactory.endpointBuilder("aws2-rekognition", path);
        }
        /**
         * AWS Rekognition (camel-aws2-rekognition)
         * Manage and invoke AWS Rekognition.
         * 
         * Category: cloud,ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-aws2-rekognition
         * 
         * Syntax: <code>aws2-rekognition:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default Rekognition2EndpointBuilder aws2Rekognition(String componentName, String path) {
            return Rekognition2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the AWS Rekognition component.
     */
    public static class Rekognition2HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Rekognition2HeaderNameBuilder INSTANCE = new Rekognition2HeaderNameBuilder();

        /**
         * The operation we want to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionOperation}.
         */
        public String awsRekognitionOperation() {
            return "CamelAwsRekognitionOperation";
        }
        /**
         * The ID of the Collection.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionCollectionId}.
         */
        public String awsRekognitionCollectionId() {
            return "CamelAwsRekognitionCollectionId";
        }
        /**
         * The ID of the User.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionUserId}.
         */
        public String awsRekognitionUserId() {
            return "CamelAwsRekognitionUserId";
        }
        /**
         * Collection of the Face IDs.
         * 
         * The option is a: {@code Collection<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionFaceIds}.
         */
        public String awsRekognitionFaceIds() {
            return "CamelAwsRekognitionFaceIds";
        }
        /**
         * Minimum user match confidence required for the face to be associated
         * with a UserID that has at least one FaceID already associated.
         * 
         * The option is a: {@code Float} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsRekognitionUserMatchThreshold}.
         */
        public String awsRekognitionUserMatchThreshold() {
            return "CamelAwsRekognitionUserMatchThreshold";
        }
        /**
         * The ID of the User.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsRekognitionClientRequestToken}.
         */
        public String awsRekognitionClientRequestToken() {
            return "CamelAwsRekognitionClientRequestToken";
        }
        /**
         * Source Input Image.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.rekognition.model.Image} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionSourceImage}.
         */
        public String awsRekognitionSourceImage() {
            return "CamelAwsRekognitionSourceImage";
        }
        /**
         * Target Input Image.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.rekognition.model.Image} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionTargetImage}.
         */
        public String awsRekognitionTargetImage() {
            return "CamelAwsRekognitionTargetImage";
        }
        /**
         * Similarity Score Threshold.
         * 
         * The option is a: {@code Float} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsRekognitionSimilarityThreshold}.
         */
        public String awsRekognitionSimilarityThreshold() {
            return "CamelAwsRekognitionSimilarityThreshold";
        }
        /**
         * Allows to filter out detected faces that dont meet a required quality
         * bar.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionQualityFilter}.
         */
        public String awsRekognitionQualityFilter() {
            return "CamelAwsRekognitionQualityFilter";
        }
        /**
         * Input Image.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.rekognition.model.Image} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionImage}.
         */
        public String awsRekognitionImage() {
            return "CamelAwsRekognitionImage";
        }
        /**
         * Facial Attributes to be returned.
         * 
         * The option is a: {@code
         * List<oftware.amazon.awssdk.services.rekognition.model.Attribute>}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsRekognitionFacialAttributes}.
         */
        public String awsRekognitionFacialAttributes() {
            return "CamelAwsRekognitionFacialAttributes";
        }
        /**
         * Maximum Labels to detect.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionMaxLabels}.
         */
        public String awsRekognitionMaxLabels() {
            return "CamelAwsRekognitionMaxLabels";
        }
        /**
         * Minimum confidence level for the labels to return.
         * 
         * The option is a: {@code Float} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionMinConfidence}.
         */
        public String awsRekognitionMinConfidence() {
            return "CamelAwsRekognitionMinConfidence";
        }
        /**
         * A list of the types of analysis to perform.
         * 
         * The option is a: {@code
         * Collection<software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionFeatures}.
         */
        public String awsRekognitionFeatures() {
            return "CamelAwsRekognitionFeatures";
        }
        /**
         * A list of the filters to be applied to returned detected labels and
         * image properties.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.rekognition.model.DetectLabelsSettings} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsRekognitionDetectLabelsSettings}.
         */
        public String awsRekognitionDetectLabelsSettings() {
            return "CamelAwsRekognitionDetectLabelsSettings";
        }
        /**
         * Sets up the configuration for human evaluation.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.rekognition.model.HumanLoopConfig}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionHumanLoopConfig}.
         */
        public String awsRekognitionHumanLoopConfig() {
            return "CamelAwsRekognitionHumanLoopConfig";
        }
        /**
         * Identifier for the custom adapter.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionProjectVersion}.
         */
        public String awsRekognitionProjectVersion() {
            return "CamelAwsRekognitionProjectVersion";
        }
        /**
         * An array of PPE types to summarize.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummarizationAttributes} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsRekognitionProtectiveEquipmentSummarizationAttributes}.
         */
        public String awsRekognitionProtectiveEquipmentSummarizationAttributes() {
            return "CamelAwsRekognitionProtectiveEquipmentSummarizationAttributes";
        }
        /**
         * An optional filter that specifies words to include in the response.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.rekognition.model.DetectTextFilters}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionWordFilter}.
         */
        public String awsRekognitionWordFilter() {
            return "CamelAwsRekognitionWordFilter";
        }
        /**
         * The ID of the celebrity to get information about.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionCelebrityId}.
         */
        public String awsRekognitionCelebrityId() {
            return "CamelAwsRekognitionCelebrityId";
        }
        /**
         * Unique identifier for the media analysis job for which you want to
         * retrieve results.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionJobId}.
         */
        public String awsRekognitionJobId() {
            return "CamelAwsRekognitionJobId";
        }
        /**
         * The name of the media analysis job.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionJobName}.
         */
        public String awsRekognitionJobName() {
            return "CamelAwsRekognitionJobName";
        }
        /**
         * Input data to be analyzed by the job.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.rekognition.model.MediaAnalysisInput}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionInput}.
         */
        public String awsRekognitionInput() {
            return "CamelAwsRekognitionInput";
        }
        /**
         * The Amazon S3 bucket location to store the results.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.rekognition.model.MediaAnalysisOutputConfig} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionOutputConfig}.
         */
        public String awsRekognitionOutputConfig() {
            return "CamelAwsRekognitionOutputConfig";
        }
        /**
         * Configuration options for the media analysis job to be created.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.rekognition.model.MediaAnalysisOperationsConfig} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsRekognitionOperationsConfig}.
         */
        public String awsRekognitionOperationsConfig() {
            return "CamelAwsRekognitionOperationsConfig";
        }
        /**
         * The identifier for your AWS Key Management Service key (AWS KMS key).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionKmsKeyId}.
         */
        public String awsRekognitionKmsKeyId() {
            return "CamelAwsRekognitionKmsKeyId";
        }
        /**
         * The ID used to identify a user in the collection.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionExternalImageId}.
         */
        public String awsRekognitionExternalImageId() {
            return "CamelAwsRekognitionExternalImageId";
        }
        /**
         * An array of facial attributes to return.
         * 
         * The option is a: {@code Collection<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsRekognitionDetectionAttributes}.
         */
        public String awsRekognitionDetectionAttributes() {
            return "CamelAwsRekognitionDetectionAttributes";
        }
        /**
         * The maximum number of faces to index.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionMaxFaces}.
         */
        public String awsRekognitionMaxFaces() {
            return "CamelAwsRekognitionMaxFaces";
        }
        /**
         * Maximum number of results to return.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionMaxResults}.
         */
        public String awsRekognitionMaxResults() {
            return "CamelAwsRekognitionMaxResults";
        }
        /**
         * Pagination token from the previous response.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionNextToken}.
         */
        public String awsRekognitionNextToken() {
            return "CamelAwsRekognitionNextToken";
        }
        /**
         * ID of a face to find matches for in the collection.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionFaceId}.
         */
        public String awsRekognitionFaceId() {
            return "CamelAwsRekognitionFaceId";
        }
        /**
         * Optional value specifying the minimum confidence in the face match to
         * return.
         * 
         * The option is a: {@code Float} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsRekognitionFaceMatchThreshold}.
         */
        public String awsRekognitionFaceMatchThreshold() {
            return "CamelAwsRekognitionFaceMatchThreshold";
        }
        /**
         * Maximum number of users to return in the response.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsRekognitionMaxUsers}.
         */
        public String awsRekognitionMaxUsers() {
            return "CamelAwsRekognitionMaxUsers";
        }
    }
    static Rekognition2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Rekognition2EndpointBuilderImpl extends AbstractEndpointBuilder implements Rekognition2EndpointBuilder, AdvancedRekognition2EndpointBuilder {
            public Rekognition2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Rekognition2EndpointBuilderImpl(path);
    }
}