/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform natural language processing using IBM Watson Natural Language
 * Understanding
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WatsonLanguageEndpointBuilderFactory {

    /**
     * Builder for endpoint for the IBM Watson Language component.
     */
    public interface WatsonLanguageEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWatsonLanguageEndpointBuilder advanced() {
            return (AdvancedWatsonLanguageEndpointBuilder) this;
        }

        /**
         * The service endpoint URL. If not specified, the default URL will be
         * used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param serviceUrl the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder serviceUrl(String serviceUrl) {
            doSetProperty("serviceUrl", serviceUrl);
            return this;
        }
        /**
         * Enable category classification.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param analyzeCategories the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeCategories(boolean analyzeCategories) {
            doSetProperty("analyzeCategories", analyzeCategories);
            return this;
        }
        /**
         * Enable category classification.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param analyzeCategories the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeCategories(String analyzeCategories) {
            doSetProperty("analyzeCategories", analyzeCategories);
            return this;
        }
        /**
         * Enable concept extraction.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param analyzeConcepts the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeConcepts(boolean analyzeConcepts) {
            doSetProperty("analyzeConcepts", analyzeConcepts);
            return this;
        }
        /**
         * Enable concept extraction.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param analyzeConcepts the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeConcepts(String analyzeConcepts) {
            doSetProperty("analyzeConcepts", analyzeConcepts);
            return this;
        }
        /**
         * Enable emotion analysis.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param analyzeEmotion the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeEmotion(boolean analyzeEmotion) {
            doSetProperty("analyzeEmotion", analyzeEmotion);
            return this;
        }
        /**
         * Enable emotion analysis.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param analyzeEmotion the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeEmotion(String analyzeEmotion) {
            doSetProperty("analyzeEmotion", analyzeEmotion);
            return this;
        }
        /**
         * Enable entity extraction.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param analyzeEntities the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeEntities(boolean analyzeEntities) {
            doSetProperty("analyzeEntities", analyzeEntities);
            return this;
        }
        /**
         * Enable entity extraction.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param analyzeEntities the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeEntities(String analyzeEntities) {
            doSetProperty("analyzeEntities", analyzeEntities);
            return this;
        }
        /**
         * Enable keyword extraction.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param analyzeKeywords the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeKeywords(boolean analyzeKeywords) {
            doSetProperty("analyzeKeywords", analyzeKeywords);
            return this;
        }
        /**
         * Enable keyword extraction.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param analyzeKeywords the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeKeywords(String analyzeKeywords) {
            doSetProperty("analyzeKeywords", analyzeKeywords);
            return this;
        }
        /**
         * Enable sentiment analysis.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param analyzeSentiment the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeSentiment(boolean analyzeSentiment) {
            doSetProperty("analyzeSentiment", analyzeSentiment);
            return this;
        }
        /**
         * Enable sentiment analysis.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param analyzeSentiment the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder analyzeSentiment(String analyzeSentiment) {
            doSetProperty("analyzeSentiment", analyzeSentiment);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.ibm.watson.language.WatsonLanguageOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder operation(org.apache.camel.component.ibm.watson.language.WatsonLanguageOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.ibm.watson.language.WatsonLanguageOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The IBM Cloud API key for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IBM Watson Language component.
     */
    public interface AdvancedWatsonLanguageEndpointBuilder
            extends
                EndpointProducerBuilder {
        default WatsonLanguageEndpointBuilder basic() {
            return (WatsonLanguageEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonLanguageEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonLanguageEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface WatsonLanguageBuilders {
        /**
         * IBM Watson Language (camel-ibm-watson-language)
         * Perform natural language processing using IBM Watson Natural Language
         * Understanding
         * 
         * Category: ai,cloud
         * Since: 4.16
         * Maven coordinates: org.apache.camel:camel-ibm-watson-language
         * 
         * @return the dsl builder for the headers' name.
         */
        default WatsonLanguageHeaderNameBuilder ibmWatsonLanguage() {
            return WatsonLanguageHeaderNameBuilder.INSTANCE;
        }
        /**
         * IBM Watson Language (camel-ibm-watson-language)
         * Perform natural language processing using IBM Watson Natural Language
         * Understanding
         * 
         * Category: ai,cloud
         * Since: 4.16
         * Maven coordinates: org.apache.camel:camel-ibm-watson-language
         * 
         * Syntax: <code>ibm-watson-language:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder ibmWatsonLanguage(String path) {
            return WatsonLanguageEndpointBuilderFactory.endpointBuilder("ibm-watson-language", path);
        }
        /**
         * IBM Watson Language (camel-ibm-watson-language)
         * Perform natural language processing using IBM Watson Natural Language
         * Understanding
         * 
         * Category: ai,cloud
         * Since: 4.16
         * Maven coordinates: org.apache.camel:camel-ibm-watson-language
         * 
         * Syntax: <code>ibm-watson-language:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default WatsonLanguageEndpointBuilder ibmWatsonLanguage(String componentName, String path) {
            return WatsonLanguageEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the IBM Watson Language component.
     */
    public static class WatsonLanguageHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final WatsonLanguageHeaderNameBuilder INSTANCE = new WatsonLanguageHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonLanguageOperation}.
         */
        public String iBMWatsonLanguageOperation() {
            return "CamelIBMWatsonLanguageOperation";
        }
        /**
         * The text to analyze.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonLanguageText}.
         */
        public String iBMWatsonLanguageText() {
            return "CamelIBMWatsonLanguageText";
        }
        /**
         * The URL to analyze.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonLanguageUrl}.
         */
        public String iBMWatsonLanguageUrl() {
            return "CamelIBMWatsonLanguageUrl";
        }
        /**
         * Enable sentiment analysis.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonLanguageAnalyzeSentiment}.
         */
        public String iBMWatsonLanguageAnalyzeSentiment() {
            return "CamelIBMWatsonLanguageAnalyzeSentiment";
        }
        /**
         * Enable emotion analysis.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonLanguageAnalyzeEmotion}.
         */
        public String iBMWatsonLanguageAnalyzeEmotion() {
            return "CamelIBMWatsonLanguageAnalyzeEmotion";
        }
        /**
         * Enable entity extraction.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonLanguageAnalyzeEntities}.
         */
        public String iBMWatsonLanguageAnalyzeEntities() {
            return "CamelIBMWatsonLanguageAnalyzeEntities";
        }
        /**
         * Enable keyword extraction.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonLanguageAnalyzeKeywords}.
         */
        public String iBMWatsonLanguageAnalyzeKeywords() {
            return "CamelIBMWatsonLanguageAnalyzeKeywords";
        }
        /**
         * Enable concept extraction.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonLanguageAnalyzeConcepts}.
         */
        public String iBMWatsonLanguageAnalyzeConcepts() {
            return "CamelIBMWatsonLanguageAnalyzeConcepts";
        }
        /**
         * Enable category classification.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonLanguageAnalyzeCategories}.
         */
        public String iBMWatsonLanguageAnalyzeCategories() {
            return "CamelIBMWatsonLanguageAnalyzeCategories";
        }
        /**
         * The language of the text.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonLanguageLanguage}.
         */
        public String iBMWatsonLanguageLanguage() {
            return "CamelIBMWatsonLanguageLanguage";
        }
        /**
         * The sentiment score.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonLanguageSentimentScore}.
         */
        public String iBMWatsonLanguageSentimentScore() {
            return "CamelIBMWatsonLanguageSentimentScore";
        }
        /**
         * The sentiment label (positive, negative, neutral).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonLanguageSentimentLabel}.
         */
        public String iBMWatsonLanguageSentimentLabel() {
            return "CamelIBMWatsonLanguageSentimentLabel";
        }
    }
    static WatsonLanguageEndpointBuilder endpointBuilder(String componentName, String path) {
        class WatsonLanguageEndpointBuilderImpl extends AbstractEndpointBuilder implements WatsonLanguageEndpointBuilder, AdvancedWatsonLanguageEndpointBuilder {
            public WatsonLanguageEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WatsonLanguageEndpointBuilderImpl(path);
    }
}