package org.apache.cayenne.testdo.testmap.auto;

import java.util.List;

import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.testdo.testmap.Artist;

/**
 * Class _ArtGroup was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _ArtGroup extends CayenneDataObject {

    public static final String NAME_PROPERTY = "name";
    public static final String ARTIST_ARRAY_PROPERTY = "artistArray";
    public static final String CHILD_GROUPS_ARRAY_PROPERTY = "childGroupsArray";
    public static final String TO_PARENT_GROUP_PROPERTY = "toParentGroup";

    public static final String GROUP_ID_PK_COLUMN = "GROUP_ID";

    public void setName(String name) {
        writeProperty(NAME_PROPERTY, name);
    }
    public String getName() {
        return (String)readProperty(NAME_PROPERTY);
    }

    public void addToArtistArray(Artist obj) {
        addToManyTarget(ARTIST_ARRAY_PROPERTY, obj, true);
    }
    public void removeFromArtistArray(Artist obj) {
        removeToManyTarget(ARTIST_ARRAY_PROPERTY, obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<Artist> getArtistArray() {
        return (List<Artist>)readProperty(ARTIST_ARRAY_PROPERTY);
    }


    public void addToChildGroupsArray(ArtGroup obj) {
        addToManyTarget(CHILD_GROUPS_ARRAY_PROPERTY, obj, true);
    }
    public void removeFromChildGroupsArray(ArtGroup obj) {
        removeToManyTarget(CHILD_GROUPS_ARRAY_PROPERTY, obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<ArtGroup> getChildGroupsArray() {
        return (List<ArtGroup>)readProperty(CHILD_GROUPS_ARRAY_PROPERTY);
    }


    public void setToParentGroup(ArtGroup toParentGroup) {
        setToOneTarget(TO_PARENT_GROUP_PROPERTY, toParentGroup, true);
    }

    public ArtGroup getToParentGroup() {
        return (ArtGroup)readProperty(TO_PARENT_GROUP_PROPERTY);
    }


}
