/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.ashwood.graph.IndegreeTopologicalSort;
import org.apache.cayenne.ashwood.graph.MapDigraph;
import org.apache.cayenne.ashwood.graph.StrongConnection;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.commons.collections.comparators.ReverseComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AshwoodEntitySorter
implements EntitySorter {
    protected EntityResolver entityResolver;
    protected Map<DbEntity, ComponentRecord> components;
    protected Map<DbEntity, List<DbRelationship>> reflexiveDbEntities;
    protected Comparator<DbEntity> dbEntityComparator = new DbEntityComparator();
    protected Comparator<ObjEntity> objEntityComparator = new ObjEntityComparator();
    private volatile boolean dirty = true;

    public AshwoodEntitySorter() {
    }

    @Deprecated
    public AshwoodEntitySorter(Collection<DataMap> dataMaps) {
        this();
        this.setDataMaps(dataMaps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexSorter() {
        boolean localDirty = this.dirty;
        if (localDirty) {
            AshwoodEntitySorter ashwoodEntitySorter = this;
            synchronized (ashwoodEntitySorter) {
                localDirty = this.dirty;
                if (localDirty) {
                    this.doIndexSorter();
                    this.dirty = false;
                }
            }
        }
    }

    protected void doIndexSorter() {
        HashMap<DbEntity, List<DbRelationship>> reflexiveDbEntities = new HashMap<DbEntity, List<DbRelationship>>(32);
        MapDigraph<DbEntity, ArrayList<DbAttribute>> referentialDigraph = new MapDigraph<DbEntity, ArrayList<DbAttribute>>();
        HashMap<String, DbEntity> tableMap = new HashMap<String, DbEntity>();
        if (this.entityResolver != null) {
            for (DbEntity entity : this.entityResolver.getDbEntities()) {
                tableMap.put(entity.getFullyQualifiedName(), entity);
                referentialDigraph.addVertex(entity);
            }
        }
        for (DbEntity destination : tableMap.values()) {
            for (DbRelationship candidate : destination.getRelationships()) {
                if ((candidate.isToMany() || candidate.isToDependentPK()) && !candidate.isToMasterPK()) continue;
                DbEntity origin = (DbEntity)candidate.getTargetEntity();
                boolean newReflexive = destination.equals(origin);
                for (DbJoin join : candidate.getJoins()) {
                    ArrayList<DbAttribute> fks;
                    DbAttribute targetAttribute = join.getTarget();
                    if (!targetAttribute.isPrimaryKey()) continue;
                    if (newReflexive) {
                        ArrayList<DbRelationship> reflexiveRels = (ArrayList<DbRelationship>)reflexiveDbEntities.get(destination);
                        if (reflexiveRels == null) {
                            reflexiveRels = new ArrayList<DbRelationship>(1);
                            reflexiveDbEntities.put(destination, reflexiveRels);
                        }
                        reflexiveRels.add(candidate);
                        newReflexive = false;
                    }
                    if ((fks = (ArrayList<DbAttribute>)referentialDigraph.getArc(origin, destination)) == null) {
                        fks = new ArrayList<DbAttribute>();
                        referentialDigraph.putArc(origin, destination, fks);
                    }
                    fks.add(targetAttribute);
                }
            }
        }
        StrongConnection contractor = new StrongConnection(referentialDigraph);
        MapDigraph contractedReferentialDigraph = new MapDigraph();
        contractor.contract(contractedReferentialDigraph);
        IndegreeTopologicalSort sorter = new IndegreeTopologicalSort(contractedReferentialDigraph);
        HashMap<DbEntity, ComponentRecord> components = new HashMap<DbEntity, ComponentRecord>(contractedReferentialDigraph.order());
        int componentIndex = 0;
        while (sorter.hasNext()) {
            Collection<DbEntity> component = sorter.next();
            ComponentRecord rec = new ComponentRecord(componentIndex++, component);
            for (DbEntity table : component) {
                components.put(table, rec);
            }
        }
        this.reflexiveDbEntities = reflexiveDbEntities;
        this.components = components;
    }

    @Override
    @Deprecated
    public void setDataMaps(Collection<DataMap> dataMaps) {
        this.setEntityResolver(new EntityResolver(dataMaps != null ? dataMaps : Collections.EMPTY_LIST));
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        this.dirty = true;
    }

    @Override
    public void sortDbEntities(List<DbEntity> dbEntities, boolean deleteOrder) {
        this.indexSorter();
        Collections.sort(dbEntities, this.getDbEntityComparator(deleteOrder));
    }

    @Override
    public void sortObjEntities(List<ObjEntity> objEntities, boolean deleteOrder) {
        this.indexSorter();
        Collections.sort(objEntities, this.getObjEntityComparator(deleteOrder));
    }

    @Override
    public void sortObjectsForEntity(ObjEntity objEntity, List<?> objects, boolean deleteOrder) {
        this.indexSorter();
        List<?> persistent = objects;
        DbEntity dbEntity = objEntity.getDbEntity();
        if (!this.isReflexive(dbEntity)) {
            return;
        }
        int size = persistent.size();
        if (size == 0) {
            return;
        }
        EntityResolver resolver = ((Persistent)persistent.get(0)).getObjectContext().getEntityResolver();
        ClassDescriptor descriptor = resolver.getClassDescriptor(objEntity.getName());
        List<DbRelationship> reflexiveRels = this.reflexiveDbEntities.get(dbEntity);
        String[] reflexiveRelNames = new String[reflexiveRels.size()];
        for (int i = 0; i < reflexiveRelNames.length; ++i) {
            DbRelationship dbRel = reflexiveRels.get(i);
            ObjRelationship objRel = dbRel != null ? objEntity.getRelationshipForDbRelationship(dbRel) : null;
            reflexiveRelNames[i] = objRel != null ? objRel.getName() : null;
        }
        ArrayList<Persistent> sorted = new ArrayList<Persistent>(size);
        MapDigraph<Persistent, Boolean> objectDependencyGraph = new MapDigraph<Persistent, Boolean>();
        Object[] masters = new Object[reflexiveRelNames.length];
        for (int i = 0; i < size; ++i) {
            Persistent current = (Persistent)objects.get(i);
            objectDependencyGraph.addVertex(current);
            int actualMasterCount = 0;
            for (int k = 0; k < reflexiveRelNames.length; ++k) {
                String reflexiveRelName = reflexiveRelNames[k];
                if (reflexiveRelName == null) continue;
                masters[k] = descriptor.getProperty(reflexiveRelName).readProperty(current);
                if (masters[k] == null) {
                    masters[k] = this.findReflexiveMaster(current, (ObjRelationship)objEntity.getRelationship(reflexiveRelName), current.getObjectId().getEntityName());
                }
                if (masters[k] == null) continue;
                ++actualMasterCount;
            }
            int mastersFound = 0;
            for (int j = 0; j < size && mastersFound < actualMasterCount; ++j) {
                if (i == j) continue;
                Persistent masterCandidate = (Persistent)persistent.get(j);
                for (Object master : masters) {
                    if (!masterCandidate.equals(master)) continue;
                    objectDependencyGraph.putArc(masterCandidate, current, Boolean.TRUE);
                    ++mastersFound;
                }
            }
        }
        IndegreeTopologicalSort sorter = new IndegreeTopologicalSort(objectDependencyGraph);
        while (sorter.hasNext()) {
            Persistent o = (Persistent)sorter.next();
            if (o == null) {
                throw new CayenneRuntimeException("Sorting objects for " + objEntity.getClassName() + " failed. Cycles found.", new Object[0]);
            }
            sorted.add(o);
        }
        persistent.clear();
        persistent.addAll(sorted);
        if (deleteOrder) {
            Collections.reverse(persistent);
        }
    }

    protected Object findReflexiveMaster(Persistent object, ObjRelationship toOneRel, String targetEntityName) {
        DbRelationship finalRel = toOneRel.getDbRelationships().get(0);
        ObjectContext context = object.getObjectContext();
        if (object.getObjectId().isTemporary()) {
            return null;
        }
        ObjectIdQuery query = new ObjectIdQuery(object.getObjectId(), true, 1);
        QueryResponse response = context.getChannel().onQuery(null, query);
        List result = response.firstList();
        if (result == null || result.size() == 0) {
            return null;
        }
        DataRow snapshot = (DataRow)result.get(0);
        ObjectId id = snapshot.createTargetObjectId(targetEntityName, finalRel);
        return id != null ? context.getGraphManager().getNode(id) : null;
    }

    protected Comparator<DbEntity> getDbEntityComparator(boolean dependantFirst) {
        ReverseComparator c = this.dbEntityComparator;
        if (dependantFirst) {
            c = new ReverseComparator(c);
        }
        return c;
    }

    protected Comparator<ObjEntity> getObjEntityComparator(boolean dependantFirst) {
        ReverseComparator c = this.objEntityComparator;
        if (dependantFirst) {
            c = new ReverseComparator(c);
        }
        return c;
    }

    protected boolean isReflexive(DbEntity metadata) {
        return this.reflexiveDbEntities.containsKey(metadata);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComponentRecord {
        int index;
        Collection<DbEntity> component;

        ComponentRecord(int index, Collection<DbEntity> component) {
            this.index = index;
            this.component = component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DbEntityComparator
    implements Comparator<DbEntity> {
        private DbEntityComparator() {
        }

        @Override
        public int compare(DbEntity t1, DbEntity t2) {
            int result = 0;
            if (t1 == t2) {
                return 0;
            }
            if (t1 == null) {
                result = -1;
            } else if (t2 == null) {
                result = 1;
            } else {
                ComponentRecord rec1 = AshwoodEntitySorter.this.components.get(t1);
                ComponentRecord rec2 = AshwoodEntitySorter.this.components.get(t2);
                int index1 = rec1.index;
                int index2 = rec2.index;
                int n = index1 > index2 ? 1 : (result = index1 < index2 ? -1 : 0);
                if (result != 0 && rec1.component == rec2.component) {
                    result = 0;
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ObjEntityComparator
    implements Comparator<ObjEntity> {
        private ObjEntityComparator() {
        }

        @Override
        public int compare(ObjEntity o1, ObjEntity o2) {
            if (o1 == o2) {
                return 0;
            }
            DbEntity t1 = o1.getDbEntity();
            DbEntity t2 = o2.getDbEntity();
            return AshwoodEntitySorter.this.dbEntityComparator.compare(t1, t2);
        }
    }
}

