/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.rop.client;

import java.util.Map;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.cache.MapQueryCacheProvider;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.rop.client.CayenneContextFactory;
import org.apache.cayenne.configuration.rop.client.ClientChannelProvider;
import org.apache.cayenne.configuration.rop.client.HessianConnectionProvider;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.remote.ClientConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientModule
implements Module {
    protected Map<String, String> properties;

    public ClientModule(Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("Null 'properties' map");
        }
        this.properties = properties;
    }

    @Override
    public void configure(Binder binder) {
        binder.bindMap("cayenne.properties").putAll(this.properties);
        binder.bind(ObjectContextFactory.class).to(CayenneContextFactory.class);
        binder.bind(ClientConnection.class).toProvider(HessianConnectionProvider.class);
        binder.bind(EventManager.class).to(DefaultEventManager.class);
        binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
        binder.bind(DataChannel.class).toProvider(ClientChannelProvider.class);
        binder.bind(QueryCache.class).toProvider(MapQueryCacheProvider.class);
    }
}

