/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.Collection;
import java.util.List;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.Scope;
import org.apache.cayenne.di.spi.Binding;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.FieldInjectingProvider;
import org.apache.cayenne.di.spi.InstanceProvider;
import org.apache.cayenne.di.spi.ListProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultListBuilder<T>
implements ListBuilder<T> {
    protected DefaultInjector injector;
    protected Key<List<?>> bindingKey;

    DefaultListBuilder(Key<List<?>> bindingKey, DefaultInjector injector) {
        this.injector = injector;
        this.bindingKey = bindingKey;
        this.getListProvider();
    }

    @Override
    public ListBuilder<T> add(Class<? extends T> interfaceType) throws ConfigurationException {
        this.getListProvider().add(this.injector.getProvider(interfaceType));
        return this;
    }

    @Override
    public ListBuilder<T> add(T value) throws ConfigurationException {
        InstanceProvider<T> provider0 = new InstanceProvider<T>(value);
        FieldInjectingProvider<T> provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
        this.getListProvider().add(provider1);
        return this;
    }

    @Override
    public ListBuilder<T> addAll(Collection<T> values) throws ConfigurationException {
        ListProvider listProvider = this.getListProvider();
        for (T value : values) {
            InstanceProvider<T> provider0 = new InstanceProvider<T>(value);
            FieldInjectingProvider<T> provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
            listProvider.add(provider1);
        }
        return this;
    }

    private ListProvider getListProvider() {
        ListProvider provider = null;
        Binding<List<?>> binding = this.injector.getBinding(this.bindingKey);
        if (binding == null) {
            provider = new ListProvider();
            this.injector.putBinding(this.bindingKey, provider);
        } else {
            provider = (ListProvider)binding.getUnscoped();
        }
        return provider;
    }

    @Override
    public void in(Scope scope) {
        this.injector.changeBindingScope(this.bindingKey, scope);
    }
}

