/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.util.ConversionUtil;

public class ASTBitwiseAnd
extends SimpleNode {
    ASTBitwiseAnd(int id) {
        super(id);
    }

    public ASTBitwiseAnd() {
        super(-1);
    }

    public ASTBitwiseAnd(SimpleNode left, SimpleNode right) {
        super(-1);
        this.jjtAddChild(left, 0);
        this.jjtAddChild(right, 1);
        this.connectChildren();
    }

    protected Object evaluateNode(Object o) throws Exception {
        int len = this.jjtGetNumChildren();
        if (len != 2) {
            return Boolean.FALSE;
        }
        long result = Long.MIN_VALUE;
        for (int i = 0; i < len; ++i) {
            long value = ConversionUtil.toLong(this.evaluateChild(i, o), Long.MIN_VALUE);
            if (value == Long.MIN_VALUE) {
                return null;
            }
            result = i == 0 ? value : result & value;
        }
        return result;
    }

    public Expression shallowCopy() {
        return new ASTBitwiseAnd(this.id);
    }

    protected String getExpressionOperator(int index) {
        return "|";
    }

    protected String getEJBQLExpressionOperator(int index) {
        throw new UnsupportedOperationException("EJBQL 'bitwise and' is not supported");
    }

    public int getType() {
        return 40;
    }
}

