/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sybase;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.map.DbEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SybasePkGenerator
extends JdbcPkGenerator {
    protected SybasePkGenerator(JdbcAdapter adapter) {
        super(adapter);
    }

    @Override
    protected String pkTableCreateString() {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE AUTO_PK_SUPPORT (").append("  TABLE_NAME CHAR(100) NOT NULL,").append("  NEXT_ID DECIMAL(19,0) NOT NULL,").append("  PRIMARY KEY(TABLE_NAME)").append(")");
        return buf.toString();
    }

    @Override
    public void createAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        super.createAutoPk(node, dbEntities);
        super.runUpdate(node, this.safePkProcDrop());
        super.runUpdate(node, this.unsafePkProcCreate());
    }

    @Override
    public List<String> createAutoPkStatements(List<DbEntity> dbEntities) {
        List<String> list = super.createAutoPkStatements(dbEntities);
        list.add(this.safePkProcDrop());
        list.add(this.unsafePkProcCreate());
        return list;
    }

    @Override
    public void dropAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        super.runUpdate(node, this.safePkProcDrop());
        super.runUpdate(node, this.safePkTableDrop());
    }

    @Override
    public List<String> dropAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.safePkProcDrop());
        list.add(this.safePkTableDrop());
        return list;
    }

    @Override
    protected long longPkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        Transaction transaction = Transaction.getThreadTransaction();
        Transaction.bindThreadTransaction(null);
        try {
            Connection connection = node.getDataSource().getConnection();
            try {
                CallableStatement statement = connection.prepareCall("{call auto_pk_for_table(?, ?)}");
                try {
                    statement.setString(1, entity.getName());
                    statement.setInt(2, super.getPkCacheSize());
                    statement.execute();
                    if (statement.getMoreResults()) {
                        ResultSet rs = statement.getResultSet();
                        try {
                            if (rs.next()) {
                                long l = rs.getLong(1);
                                return l;
                            }
                            throw new CayenneRuntimeException("Error generating pk for DbEntity " + entity.getName(), new Object[0]);
                        }
                        finally {
                            rs.close();
                        }
                    }
                    throw new CayenneRuntimeException("Error generating pk for DbEntity " + entity.getName() + ", no result set from stored procedure.", new Object[0]);
                }
                finally {
                    statement.close();
                }
            }
            finally {
                connection.close();
            }
        }
        finally {
            Transaction.bindThreadTransaction(transaction);
        }
    }

    private String safePkTableDrop() {
        StringBuilder buf = new StringBuilder();
        buf.append("if exists (SELECT * FROM sysobjects WHERE name = 'AUTO_PK_SUPPORT')").append(" BEGIN ").append(" DROP TABLE AUTO_PK_SUPPORT").append(" END");
        return buf.toString();
    }

    private String unsafePkProcCreate() {
        StringBuilder buf = new StringBuilder();
        buf.append(" CREATE PROCEDURE auto_pk_for_table @tname VARCHAR(32), @pkbatchsize INT AS").append(" BEGIN").append(" BEGIN TRANSACTION").append(" UPDATE AUTO_PK_SUPPORT set NEXT_ID = NEXT_ID + @pkbatchsize").append(" WHERE TABLE_NAME = @tname").append(" SELECT NEXT_ID FROM AUTO_PK_SUPPORT WHERE TABLE_NAME = @tname").append(" COMMIT").append(" END");
        return buf.toString();
    }

    private String safePkProcDrop() {
        StringBuilder buf = new StringBuilder();
        buf.append("if exists (SELECT * FROM sysobjects WHERE name = 'auto_pk_for_table')").append(" BEGIN").append(" DROP PROCEDURE auto_pk_for_table").append(" END");
        return buf.toString();
    }
}

