/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.apache.cayenne.pref.CayennePreference;
import org.apache.cayenne.pref.UpgradeCayennePreference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelerPreferences
implements PreferenceChangeListener {
    private static Preferences cayennePrefs;
    private static final Log logObj;
    public static final String LOGFILE_NAME = "modeler.log";
    public static final int LAST_PROJ_FILES_SIZE = 12;
    public static final String EDITOR_LOGFILE_ENABLED = "logfileEnabled";
    public static final String EDITOR_LOGFILE = "logfile";
    public static final int COMBOBOX_MAX_VISIBLE_SIZE = 12;

    public static Preferences getPreferences() {
        if (cayennePrefs == null) {
            UpgradeCayennePreference decoratedPref = new UpgradeCayennePreference(new CayennePreference());
            cayennePrefs = decoratedPref.getCayennePreference();
            cayennePrefs.addPreferenceChangeListener(new ModelerPreferences());
        }
        return cayennePrefs;
    }

    public static Preferences getEditorPreferences() {
        return ModelerPreferences.getPreferences().node("editor");
    }

    public static Preferences getLastProjFilesPref() {
        return ModelerPreferences.getEditorPreferences().node("lastSeveralProjectFiles");
    }

    public static List<String> getLastProjFiles() {
        Preferences filesPrefs = ModelerPreferences.getLastProjFilesPref();
        ArrayList<String> arrayLastProjFiles = new ArrayList<String>();
        String[] keys = null;
        try {
            keys = filesPrefs.keys();
        }
        catch (BackingStoreException e) {
            logObj.warn("Error reading preferences file.", e);
        }
        if (keys != null) {
            int i;
            int len = keys.length;
            ArrayList<Integer> keysInteger = new ArrayList<Integer>();
            for (i = 0; i < len; ++i) {
                keysInteger.add(new Integer(i));
            }
            Collections.sort(keysInteger);
            for (i = 0; i < len; ++i) {
                arrayLastProjFiles.add(filesPrefs.get(((Integer)keysInteger.get(i)).toString(), ""));
            }
        }
        return arrayLastProjFiles;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        evt.getNode().put(evt.getKey(), evt.getNewValue());
    }

    static {
        logObj = LogFactory.getLog(ModelerPreferences.class);
    }
}

