/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.validator;

import javax.swing.JFrame;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.validator.AttributeErrorMsg;
import org.apache.cayenne.modeler.dialog.validator.DataMapErrorMsg;
import org.apache.cayenne.modeler.dialog.validator.DataNodeErrorMsg;
import org.apache.cayenne.modeler.dialog.validator.DomainErrorMsg;
import org.apache.cayenne.modeler.dialog.validator.EmbeddableAttributeErrorMsg;
import org.apache.cayenne.modeler.dialog.validator.EmbeddableErrorMsg;
import org.apache.cayenne.modeler.dialog.validator.EntityErrorMsg;
import org.apache.cayenne.modeler.dialog.validator.ProcedureErrorMsg;
import org.apache.cayenne.modeler.dialog.validator.ProcedureParameterErrorMsg;
import org.apache.cayenne.modeler.dialog.validator.QueryErrorMsg;
import org.apache.cayenne.modeler.dialog.validator.RelationshipErrorMsg;
import org.apache.cayenne.modeler.pref.DataNodeDefaults;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ValidationDisplayHandler {
    private static Log logObj = LogFactory.getLog(ValidationDisplayHandler.class);
    public static final int NO_ERROR = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    protected ValidationFailure validationFailure;
    protected DataChannelDescriptor domain;

    public static ValidationDisplayHandler getErrorMsg(ValidationFailure result) {
        Object validatedObj = result.getSource();
        ValidationDisplayHandler msg = null;
        if (validatedObj instanceof Embeddable) {
            msg = new EmbeddableErrorMsg(result);
        } else if (validatedObj instanceof Attribute) {
            msg = new AttributeErrorMsg(result);
        } else if (validatedObj instanceof EmbeddableAttribute) {
            msg = new EmbeddableAttributeErrorMsg(result);
        } else if (validatedObj instanceof Relationship) {
            msg = new RelationshipErrorMsg(result);
        } else if (validatedObj instanceof Entity) {
            msg = new EntityErrorMsg(result);
        } else if (validatedObj instanceof DataNodeDefaults) {
            msg = new DataNodeErrorMsg(result);
        } else if (validatedObj instanceof DataMap) {
            msg = new DataMapErrorMsg(result);
        } else if (validatedObj instanceof DataChannelDescriptor) {
            msg = new DomainErrorMsg(result);
        } else if (validatedObj instanceof Procedure) {
            msg = new ProcedureErrorMsg(result);
        } else if (validatedObj instanceof ProcedureParameter) {
            msg = new ProcedureParameterErrorMsg(result);
        } else if (validatedObj instanceof Query) {
            msg = new QueryErrorMsg(result);
        } else {
            logObj.info("unknown project node: " + validatedObj);
            msg = new NullHanlder(result);
        }
        return msg;
    }

    public ValidationDisplayHandler(ValidationFailure validationFailure) {
        this.validationFailure = validationFailure;
    }

    public abstract void displayField(ProjectController var1, JFrame var2);

    public String getMessage() {
        return this.validationFailure.getDescription();
    }

    public DataChannelDescriptor getDomain() {
        return this.domain;
    }

    public void setDomain(DataChannelDescriptor domain) {
        this.domain = domain;
    }

    public String toString() {
        return this.getMessage();
    }

    public Object getObject() {
        return this.validationFailure.getSource();
    }

    public ValidationFailure getValidationFailure() {
        return this.validationFailure;
    }

    private static final class NullHanlder
    extends ValidationDisplayHandler {
        NullHanlder(ValidationFailure info) {
            super(info);
        }

        public void displayField(ProjectController mediator, JFrame frame) {
        }
    }
}

