/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.DataDomainView;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.graph.DataDomainGraphTab;

public class DataDomainTabbedView
extends JTabbedPane
implements ChangeListener,
DomainDisplayListener {
    ProjectController mediator;
    DataDomainGraphTab graphTab;

    public DataDomainTabbedView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    private void initView() {
        this.setTabPlacement(1);
        JScrollPane domainView = new JScrollPane(new DataDomainView(this.mediator));
        this.addTab("Main", domainView);
        this.graphTab = new DataDomainGraphTab(this.mediator);
        this.addTab("Graph", this.graphTab);
        this.addChangeListener(this);
        this.mediator.addDomainDisplayListener(this);
    }

    public void stateChanged(ChangeEvent e) {
        if (this.getSelectedComponent() == this.graphTab) {
            this.graphTab.refresh();
        }
    }

    public void currentDomainChanged(DomainDisplayEvent e) {
        if (e instanceof EntityDisplayEvent) {
            this.setSelectedComponent(this.graphTab);
        }
    }
}

