/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.tools.NamePatternMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CayenneGeneratorEntityFilterAction {
    private NamePatternMatcher nameFilter;
    private boolean client;

    CayenneGeneratorEntityFilterAction() {
    }

    Collection<Embeddable> getFilteredEmbeddables(DataMap mainDataMap) {
        ArrayList<Embeddable> embeddables = new ArrayList<Embeddable>(mainDataMap.getEmbeddables());
        Iterator it = embeddables.iterator();
        while (it.hasNext()) {
            Embeddable e = (Embeddable)it.next();
            if (this.nameFilter.isIncluded(e.getClassName())) continue;
            it.remove();
        }
        return embeddables;
    }

    Collection<ObjEntity> getFilteredEntities(DataMap mainDataMap) throws MalformedURLException {
        ArrayList<ObjEntity> entities = new ArrayList<ObjEntity>(mainDataMap.getObjEntities());
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            ObjEntity e = (ObjEntity)it.next();
            if (e.isGeneric()) {
                it.remove();
                continue;
            }
            if (this.client && !e.isClientAllowed()) {
                it.remove();
                continue;
            }
            if (this.nameFilter.isIncluded(e.getName())) continue;
            it.remove();
        }
        return entities;
    }

    void setClient(boolean client) {
        this.client = client;
    }

    public void setNameFilter(NamePatternMatcher nameFilter) {
        this.nameFilter = nameFilter;
    }
}

