/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.openbase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.CreateTableToDb;
import org.apache.cayenne.merge.DropRelationshipToDb;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.SetAllowNullToDb;
import org.apache.cayenne.merge.SetColumnTypeToDb;
import org.apache.cayenne.merge.SetNotNullToDb;

public class OpenBaseMergerFactory
extends MergerFactory {
    public MergerToken createCreateTableToDb(DbEntity entity) {
        return new CreateTableToDb(entity){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                ArrayList<String> sqls = new ArrayList<String>();
                sqls.add(adapter.createTable(this.getEntity()));
                sqls.addAll(adapter.getPkGenerator().createAutoPkStatements(Collections.singletonList(this.getEntity())));
                return sqls;
            }
        };
    }

    public MergerToken createDropRelationshipToDb(DbEntity entity, final DbRelationship rel) {
        return new DropRelationshipToDb(entity, rel){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuilder buf = new StringBuilder();
                buf.append("delete from _SYS_RELATIONSHIP where ");
                DbEntity source = this.getEntity();
                DbEntity dest = (DbEntity)rel.getTargetEntity();
                DbJoin join = rel.getJoins().get(0);
                buf.append(" source_table = '");
                buf.append(dest.getFullyQualifiedName());
                buf.append("'");
                buf.append(" and source_column = '");
                buf.append(join.getTargetName());
                buf.append("'");
                buf.append(" and dest_table = '");
                buf.append(source.getFullyQualifiedName());
                buf.append("'");
                buf.append(" and dest_column = '");
                buf.append(join.getSourceName());
                buf.append("'");
                return Collections.singletonList(buf.toString());
            }
        };
    }

    public MergerToken createSetColumnTypeToDb(final DbEntity entity, final DbAttribute columnOriginal, final DbAttribute columnNew) {
        return new SetColumnTypeToDb(entity, columnOriginal, columnNew){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                ArrayList<String> sqls = new ArrayList<String>();
                if (columnOriginal.getMaxLength() != columnNew.getMaxLength()) {
                    sqls.add("ALTER TABLE " + entity.getFullyQualifiedName() + " COLUMN " + columnNew.getName() + " SET LENGTH " + columnNew.getMaxLength());
                }
                return sqls;
            }
        };
    }

    public MergerToken createSetNotNullToDb(DbEntity entity, DbAttribute column) {
        return new SetNotNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuilder sqlBuffer = new StringBuilder();
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(this.getEntity().getFullyQualifiedName());
                sqlBuffer.append(" COLUMN ");
                sqlBuffer.append(this.getColumn().getName());
                sqlBuffer.append(" SET NOT NULL");
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }

    public MergerToken createSetAllowNullToDb(DbEntity entity, DbAttribute column) {
        return new SetAllowNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuilder sqlBuffer = new StringBuilder();
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(this.getEntity().getFullyQualifiedName());
                sqlBuffer.append(" COLUMN ");
                sqlBuffer.append(this.getColumn().getName());
                sqlBuffer.append(" SET NULL");
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }
}

