/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.ExpressionParameter;
import org.apache.cayenne.exp.TraversalHandler;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ExpressionParser;
import org.apache.cayenne.exp.parser.ExpressionParserTokenManager;
import org.apache.cayenne.exp.parser.JavaCharStream;
import org.apache.cayenne.exp.parser.ParseException;
import org.apache.cayenne.util.ConversionUtil;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.commons.collections.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
implements Serializable,
XMLSerializable {
    public static final Object PRUNED_NODE = new Object();
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    public static final int EQUAL_TO = 3;
    public static final int NOT_EQUAL_TO = 4;
    public static final int LESS_THAN = 5;
    public static final int GREATER_THAN = 6;
    public static final int LESS_THAN_EQUAL_TO = 7;
    public static final int GREATER_THAN_EQUAL_TO = 8;
    public static final int BETWEEN = 9;
    public static final int IN = 10;
    public static final int LIKE = 11;
    public static final int LIKE_IGNORE_CASE = 12;
    public static final int ADD = 16;
    public static final int SUBTRACT = 17;
    public static final int MULTIPLY = 18;
    public static final int DIVIDE = 19;
    public static final int NEGATIVE = 20;
    public static final int TRUE = 21;
    public static final int FALSE = 22;
    public static final int OBJ_PATH = 26;
    public static final int DB_PATH = 27;
    public static final int LIST = 28;
    public static final int NOT_BETWEEN = 35;
    public static final int NOT_IN = 36;
    public static final int NOT_LIKE = 37;
    public static final int NOT_LIKE_IGNORE_CASE = 38;
    public static final int BITWISE_NOT = 39;
    public static final int BITWISE_AND = 40;
    public static final int BITWISE_OR = 41;
    public static final int BITWISE_XOR = 42;
    private static final int PARSE_BUFFER_MAX_SIZE = 4096;
    protected int type;

    public static Expression fromString(String expressionString) {
        if (expressionString == null) {
            throw new NullPointerException("Null expression string.");
        }
        int bufferSize = expressionString.length() > 4096 ? 4096 : expressionString.length() + 1;
        StringReader reader = new StringReader(expressionString);
        JavaCharStream stream = new JavaCharStream(reader, 1, 1, bufferSize);
        ExpressionParserTokenManager tm = new ExpressionParserTokenManager(stream);
        ExpressionParser parser = new ExpressionParser(tm);
        try {
            return parser.expression();
        }
        catch (ParseException ex) {
            String message = ex.getMessage();
            throw new ExpressionException(message != null ? message : "", (Throwable)ex, new Object[0]);
        }
        catch (Throwable th) {
            String message = th.getMessage();
            throw new ExpressionException(message != null ? message : "", th, new Object[0]);
        }
    }

    public abstract Map<String, String> getPathAliases();

    public String expName() {
        switch (this.type) {
            case 0: {
                return "AND";
            }
            case 1: {
                return "OR";
            }
            case 2: {
                return "NOT";
            }
            case 3: {
                return "=";
            }
            case 4: {
                return "<>";
            }
            case 5: {
                return "<";
            }
            case 7: {
                return "<=";
            }
            case 6: {
                return ">";
            }
            case 8: {
                return ">=";
            }
            case 9: {
                return "BETWEEN";
            }
            case 10: {
                return "IN";
            }
            case 11: {
                return "LIKE";
            }
            case 12: {
                return "LIKE_IGNORE_CASE";
            }
            case 26: {
                return "OBJ_PATH";
            }
            case 27: {
                return "DB_PATH";
            }
            case 28: {
                return "LIST";
            }
            case 35: {
                return "NOT BETWEEN";
            }
            case 36: {
                return "NOT IN";
            }
            case 37: {
                return "NOT LIKE";
            }
            case 38: {
                return "NOT LIKE IGNORE CASE";
            }
        }
        return "other";
    }

    public boolean equals(Object object) {
        if (!(object instanceof Expression)) {
            return false;
        }
        Expression e = (Expression)object;
        if (e.getType() != this.getType() || e.getOperandCount() != this.getOperandCount()) {
            return false;
        }
        int len = e.getOperandCount();
        for (int i = 0; i < len; ++i) {
            if (Util.nullSafeEquals(e.getOperand(i), this.getOperand(i))) continue;
            return false;
        }
        return true;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Expression expWithParameters(Map<String, ?> parameters) {
        return this.expWithParameters(parameters, true);
    }

    public Expression expWithParameters(final Map<String, ?> parameters, final boolean pruneMissing) {
        Transformer transformer = new Transformer(){

            public Object transform(Object object) {
                if (!(object instanceof ExpressionParameter)) {
                    if (object instanceof Object[]) {
                        Object[] source = (Object[])object;
                        int len = source.length;
                        Object[] target = new Object[len];
                        for (int i = 0; i < len; ++i) {
                            target[i] = this.transform(source[i]);
                        }
                        return target;
                    }
                    return object;
                }
                String name = ((ExpressionParameter)object).getName();
                if (!parameters.containsKey(name)) {
                    if (pruneMissing) {
                        return PRUNED_NODE;
                    }
                    throw new ExpressionException("Missing required parameter: $" + name, new Object[0]);
                }
                Object value = parameters.get(name);
                return value != null ? ExpressionFactory.wrapPathOperand(value) : new ASTScalar(null);
            }
        };
        return this.transform(transformer);
    }

    public Expression joinExp(int type, Expression exp) {
        Expression join = ExpressionFactory.expressionOfType(type);
        join.setOperand(0, this);
        join.setOperand(1, exp);
        join.flattenTree();
        return join;
    }

    public Expression andExp(Expression exp) {
        return this.joinExp(0, exp);
    }

    public Expression orExp(Expression exp) {
        return this.joinExp(1, exp);
    }

    public abstract Expression notExp();

    public abstract int getOperandCount();

    public abstract Object getOperand(int var1);

    public abstract void setOperand(int var1, Object var2);

    public abstract Object evaluate(Object var1);

    public boolean match(Object o) {
        return ConversionUtil.toBoolean(this.evaluate(o));
    }

    public <T> T first(List<T> objects) {
        for (T o : objects) {
            if (!this.match(o)) continue;
            return o;
        }
        return null;
    }

    public <T> List<T> filterObjects(List<T> objects) {
        if (objects == null || objects.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return (List)this.filter(objects, new LinkedList());
    }

    public <T> Collection<?> filter(Collection<T> source, Collection<T> target) {
        for (T o : source) {
            if (!this.match(o)) continue;
            target.add(o);
        }
        return target;
    }

    public Expression deepCopy() {
        return this.transform(null);
    }

    public abstract Expression shallowCopy();

    protected abstract boolean pruneNodeForPrunedChild(Object var1);

    protected abstract void flattenTree();

    public void traverse(TraversalHandler visitor) {
        if (visitor == null) {
            throw new NullPointerException("Null Visitor.");
        }
        this.traverse(null, visitor);
    }

    protected void traverse(Expression parentExp, TraversalHandler visitor) {
        visitor.startNode(this, parentExp);
        int count = this.getOperandCount();
        for (int i = 0; i < count; ++i) {
            Object child = this.getOperand(i);
            if (child instanceof Expression) {
                Expression childExp = (Expression)child;
                childExp.traverse(this, visitor);
            } else {
                visitor.objectNode(child, this);
            }
            visitor.finishedChild(this, i, i < count - 1);
        }
        visitor.endNode(this, parentExp);
    }

    public Expression transform(Transformer transformer) {
        Object transformed = this.transformExpression(transformer);
        if (transformed == PRUNED_NODE || transformed == null) {
            return null;
        }
        if (transformed instanceof Expression) {
            return (Expression)transformed;
        }
        throw new ExpressionException("Invalid transformed expression: " + transformed, new Object[0]);
    }

    protected Object transformExpression(Transformer transformer) {
        Expression copy = this.shallowCopy();
        int count = this.getOperandCount();
        int j = 0;
        for (int i = 0; i < count; ++i) {
            boolean prune;
            Object operand = this.getOperand(i);
            Object transformedChild = operand instanceof Expression ? ((Expression)operand).transformExpression(transformer) : (transformer != null ? transformer.transform(operand) : operand);
            boolean bl = prune = transformer != null && transformedChild == PRUNED_NODE;
            if (!prune) {
                copy.setOperand(j, transformedChild);
                ++j;
            }
            if (!prune || !this.pruneNodeForPrunedChild(operand)) continue;
            return PRUNED_NODE;
        }
        return transformer != null ? (Expression)transformer.transform((Object)copy) : copy;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<![CDATA[");
        this.encodeAsString(encoder.getPrintWriter());
        encoder.print("]]>");
    }

    public abstract void encodeAsString(PrintWriter var1);

    public abstract void encodeAsEJBQL(PrintWriter var1, String var2);

    public String toString() {
        StringWriter buffer = new StringWriter();
        PrintWriter pw = new PrintWriter(buffer);
        this.encodeAsString(pw);
        pw.close();
        buffer.flush();
        return buffer.toString();
    }

    public String toEJBQL(String rootId) {
        StringWriter buffer = new StringWriter();
        PrintWriter pw = new PrintWriter(buffer);
        this.encodeAsEJBQL(pw, rootId);
        pw.close();
        buffer.flush();
        return buffer.toString();
    }
}

