/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.EmbeddableDescriptor;
import org.apache.cayenne.reflect.FieldAccessor;
import org.apache.cayenne.reflect.PropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldEmbeddableDescriptor
implements EmbeddableDescriptor {
    protected Class<?> embeddableClass;
    protected Embeddable embeddable;
    protected Accessor ownerAccessor;
    protected Accessor embeddedPropertyAccessor;

    public FieldEmbeddableDescriptor(Embeddable embeddable, String ownerProperty, String embeddedPropertyProperty) {
        this.embeddable = embeddable;
        try {
            this.embeddableClass = Class.forName(embeddable.getClassName(), true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new PropertyException("Class not found", (Throwable)e, new Object[0]);
        }
        this.ownerAccessor = new FieldAccessor(this.embeddableClass, ownerProperty, Persistent.class);
        this.embeddedPropertyAccessor = new FieldAccessor(this.embeddableClass, embeddedPropertyProperty, String.class);
    }

    @Override
    public Object createObject(Object owner, String embeddedProperty) {
        Object embeddable;
        try {
            embeddable = this.embeddableClass.newInstance();
        }
        catch (Throwable e) {
            throw new PropertyException("Error creating embeddable object of class '" + this.embeddableClass.getName() + "'", e, new Object[0]);
        }
        this.ownerAccessor.setValue(embeddable, owner);
        this.embeddedPropertyAccessor.setValue(embeddable, embeddedProperty);
        return embeddable;
    }

    @Override
    public Embeddable getEmbeddable() {
        return this.embeddable;
    }

    @Override
    public Class<?> getObjectClass() {
        return this.embeddableClass;
    }
}

