/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.model.DetectedDbEntity;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.PerCatalogAndSchemaLoader;
import org.apache.cayenne.dbsync.reverse.filters.CatalogFilter;
import org.apache.cayenne.dbsync.reverse.filters.SchemaFilter;
import org.apache.cayenne.map.DbEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntityLoader
extends PerCatalogAndSchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLoader.class);
    private final String[] types = this.getTableTypes();

    EntityLoader(DbAdapter adapter, DbLoaderConfiguration config, DbLoaderDelegate delegate) {
        super(adapter, config, delegate);
    }

    @Override
    protected ResultSet getResultSet(String catalogName, String schemaName, DatabaseMetaData metaData) throws SQLException {
        return metaData.getTables(catalogName, schemaName, "%", this.types);
    }

    @Override
    protected void processResultSetRow(CatalogFilter catalog, SchemaFilter schema, DbLoadDataStore map, ResultSet rs) throws SQLException {
        String name = rs.getString("TABLE_NAME");
        String catalogName = rs.getString("TABLE_CAT");
        String schemaName = rs.getString("TABLE_SCHEM");
        String type = rs.getString("TABLE_TYPE");
        if (name == null || !schema.tables.isIncludeTable(name)) {
            return;
        }
        if (catalog.name != null && !catalog.name.equals(catalogName) || schema.name != null && !schema.name.equals(schemaName)) {
            LOGGER.error(catalogName + "." + schema + "." + schemaName + " wrongly loaded for catalog/schema : " + catalog.name + "." + schema.name);
            return;
        }
        DetectedDbEntity table = new DetectedDbEntity(name);
        table.setCatalog(catalogName);
        table.setSchema(schemaName);
        table.setType(type);
        this.addDbEntityToMap(table, map);
    }

    private void addDbEntityToMap(DetectedDbEntity table, DbLoadDataStore map) {
        DbEntity oldEnt = map.addDbEntitySafe(table);
        if (oldEnt != null) {
            LOGGER.warn("Overwrite DbEntity: " + oldEnt.getName());
            this.delegate.dbEntityRemoved(oldEnt);
        }
        this.delegate.dbEntityAdded(table);
    }

    private String[] getTableTypes() {
        String[] configTypes = this.config.getTableTypes();
        String viewType = this.adapter.tableTypeForView();
        String tableType = this.adapter.tableTypeForTable();
        ArrayList<String> resultTableTypes = new ArrayList<String>();
        if (configTypes == null || configTypes.length == 0) {
            this.addTypeToList(viewType, resultTableTypes);
            this.addTypeToList(tableType, resultTableTypes);
        } else {
            for (String type : configTypes) {
                if (type.equalsIgnoreCase("TABLE")) {
                    this.addTypeToList(tableType, resultTableTypes);
                    continue;
                }
                if (type.equalsIgnoreCase("VIEW")) {
                    this.addTypeToList(viewType, resultTableTypes);
                    continue;
                }
                this.addTypeToList(type, resultTableTypes);
            }
        }
        return resultTableTypes.toArray(new String[0]);
    }

    private void addTypeToList(String type, List<String> tableTypes) {
        if (type != null) {
            tableTypes.add(type);
        }
    }
}

